/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.functionaltests.forms;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.nuxeo.functionaltests.forms.WidgetElement;
import org.openqa.selenium.By;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;

public class SelectManyCheckboxDirectoryWidgetElement
extends WidgetElement {
    public SelectManyCheckboxDirectoryWidgetElement(WebDriver driver, String id) {
        super(driver, id);
    }

    @Override
    public void setInput(WebElement elt, String value) {
        List options = this.getInputElement().findElements(By.xpath((String)".//input[@type='checkbox']"));
        ArrayList<String> ids = new ArrayList<String>();
        if (StringUtils.isBlank((String)value)) {
            for (WebElement option : options) {
                if (!option.isSelected()) continue;
                ids.add(option.getAttribute("id"));
            }
        } else {
            WebElement split;
            for (WebElement v : split = value.split(",")) {
                for (WebElement option : options) {
                    if (!option.getAttribute("value").equals(v) || option.isSelected()) continue;
                    ids.add(option.getAttribute("id"));
                }
            }
        }
        for (String id : ids) {
            this.driver.findElement(By.id((String)id)).click();
        }
    }

    @Override
    public String getInputValue() {
        StringBuilder res = new StringBuilder();
        List options = this.getInputElement().findElements(By.xpath((String)".//input[type='checkbox']"));
        for (WebElement option : options) {
            if (!option.isSelected()) continue;
            if (res.length() != 0) {
                res.append(",");
            }
            res.append(option.getAttribute("value"));
        }
        return res.toString();
    }
}

