/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.functionaltests.fragment;

import com.google.common.base.Function;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.functionaltests.fragment.WebFragmentImpl;
import org.openqa.selenium.By;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.ui.FluentWait;

public class GadgetsContainerFragment
extends WebFragmentImpl {
    private static final Log log = LogFactory.getLog(GadgetsContainerFragment.class);
    public static final String GADGETS_CONTAINER_ID = "gwtContainerDiv";

    public GadgetsContainerFragment(WebDriver driver, WebElement element) {
        super(driver, element);
    }

    public WebElement waitForGadgetsLoad() {
        return this.waitForGadgetsLoad("nxDocumentListData,content");
    }

    public WebElement waitForGadgetsLoad(final String mandatoryElements) {
        FluentWait wait = new FluentWait((Object)this.driver).withTimeout(30L, TimeUnit.SECONDS).pollingEvery(5L, TimeUnit.SECONDS).ignoring(NoSuchElementException.class);
        return (WebElement)wait.until((Function)new Function<WebDriver, WebElement>(){

            public WebElement apply(WebDriver driver) {
                WebElement container = GadgetsContainerFragment.this.getElement();
                boolean oneFound = false;
                List framesList = driver.findElements(By.xpath((String)"//iframe"));
                if (framesList != null && !framesList.isEmpty()) {
                    List<String> mandatory = Arrays.asList(mandatoryElements.split(","));
                    for (WebElement frame : framesList) {
                        String frameName = frame.getAttribute("name");
                        if (frameName == null || !frameName.startsWith("open-social")) continue;
                        log.debug((Object)String.format("Found one GWT gadget frame named '%s' ", frameName));
                        oneFound = true;
                        boolean loaded = false;
                        driver.switchTo().defaultContent();
                        driver.switchTo().frame(frame);
                        for (String mand : mandatory) {
                            try {
                                driver.findElement(By.id((String)mand));
                                loaded = true;
                                log.debug((Object)String.format("Gadget frame '%s' mandatory element '%s' loaded", frameName, mand));
                            }
                            catch (NoSuchElementException e) {
                                loaded = false;
                                log.debug((Object)String.format("Gadget frame '%s' not loaded yet, mandatory element '%s' not found", frameName, mand));
                                break;
                            }
                        }
                        if (!loaded) {
                            log.debug((Object)String.format("Gadget frame '%s' not loaded yet", frameName));
                            driver.switchTo().defaultContent();
                            return null;
                        }
                        log.debug((Object)String.format("Gadget frame '%s' loaded", frameName));
                        driver.switchTo().defaultContent();
                    }
                }
                if (oneFound) {
                    return container;
                }
                log.debug((Object)"No gadget frame loaded yet");
                return null;
            }
        });
    }

    public boolean isGadgetLoaded(String gadgetTitle) {
        return this.getGadgetTitleElement(gadgetTitle) != null;
    }

    public WebElement getGadgetTitleElement(String gadgetTitle) {
        WebElement gtwContainer = this.waitForGadgetsLoad();
        List gadgets = gtwContainer.findElements(By.className((String)"dragdrop-draggable"));
        for (WebElement gadget : gadgets) {
            WebElement title = gadget.findElement(By.className((String)"header"));
            if (!title.getText().contains(gadgetTitle)) continue;
            return title;
        }
        throw new NoSuchElementException(gadgetTitle);
    }

    public boolean isTaskGadgetEmpty(String gadgetTitle) {
        WebDriver driver = this.switchToFrame(gadgetTitle);
        boolean res = driver.findElement(By.id((String)"nxDocumentListData")).getText().contains("Your dashboard is empty. There are no tasks that require your intervention.");
        driver.switchTo().defaultContent();
        return res;
    }

    public WebDriver switchToFrame(String gadgetTitle) {
        WebElement title = this.getGadgetTitleElement(gadgetTitle);
        WebElement parent = title.findElement(By.xpath((String)"parent::*"));
        this.driver.switchTo().defaultContent();
        return this.driver.switchTo().frame("open-social-" + parent.getAttribute("id"));
    }
}

