/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.functionaltests.pages;

import org.nuxeo.functionaltests.AjaxRequestManager;
import org.nuxeo.functionaltests.Required;
import org.nuxeo.functionaltests.pages.CollectionsPage;
import org.nuxeo.functionaltests.pages.DocumentBasePage;
import org.openqa.selenium.By;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.FindBy;

public class HomePage
extends DocumentBasePage {
    static final String COLLECTIONS_LABEL = "Collections";
    static final String SEARCHES_LABEL = "Searches";
    @Required
    @FindBy(id="nxw_homeTabs_panel")
    protected WebElement menu;

    public HomePage(WebDriver driver) {
        super(driver);
    }

    public CollectionsPage goToCollections() {
        this.goTo(COLLECTIONS_LABEL);
        return this.asPage(CollectionsPage.class);
    }

    public HomePage goToSavedSearches() {
        this.goTo(SEARCHES_LABEL);
        return this.asPage(HomePage.class);
    }

    private void goTo(String label) {
        if (this.useAjaxTabs()) {
            AjaxRequestManager arm = new AjaxRequestManager(this.driver);
            arm.begin();
            this.menu.findElement(By.linkText((String)label)).click();
            arm.end();
        } else {
            this.menu.findElement(By.linkText((String)label)).click();
        }
    }
}

