/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.functionaltests.pages;

import org.nuxeo.functionaltests.fragment.GadgetsContainerFragment;
import org.nuxeo.functionaltests.pages.AbstractPage;
import org.nuxeo.functionaltests.pages.WorkflowHomePage;
import org.nuxeo.functionaltests.pages.tabs.SummaryTabSubPage;
import org.openqa.selenium.By;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.FindBy;

public class UserHomePage
extends AbstractPage {
    @FindBy(id="gwtContainerDiv")
    public WebElement gadgetsContainer;
    protected GadgetsContainerFragment gadgetsFragment;

    public UserHomePage(WebDriver driver) {
        super(driver);
    }

    protected GadgetsContainerFragment getGadgetsFragment() {
        if (this.gadgetsFragment == null) {
            this.gadgetsFragment = this.getWebFragment(this.gadgetsContainer, GadgetsContainerFragment.class);
        }
        return this.gadgetsFragment;
    }

    public boolean isTaskGadgetLoaded() {
        return this.getGadgetsFragment().isGadgetLoaded("My Tasks");
    }

    public SummaryTabSubPage redirectToTask(String taskTitle) {
        WebDriver driver = this.getGadgetsFragment().switchToFrame("My Tasks");
        driver.findElement(By.linkText((String)taskTitle)).click();
        return new SummaryTabSubPage(driver);
    }

    public boolean isTaskGadgetEmpty() {
        return this.getGadgetsFragment().isTaskGadgetEmpty("My Tasks");
    }

    public WorkflowHomePage getWorkflowHomePage() {
        UserHomePage.findElementWithTimeout(By.linkText((String)"Workflow")).click();
        return this.asPage(WorkflowHomePage.class);
    }

    public UserHomePage goToDashboard() {
        UserHomePage.findElementWithTimeout(By.linkText((String)"Dashboard")).click();
        return this;
    }
}

