/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.functionaltests.pages.forms;

import java.io.IOException;
import org.nuxeo.functionaltests.forms.FileWidgetElement;
import org.nuxeo.functionaltests.forms.LayoutElement;
import org.nuxeo.functionaltests.pages.FileDocumentBasePage;
import org.nuxeo.functionaltests.pages.forms.DublinCoreCreationDocumentFormPage;
import org.openqa.selenium.WebDriver;

public class FileCreationFormPage
extends DublinCoreCreationDocumentFormPage {
    public FileCreationFormPage(WebDriver driver) {
        super(driver);
    }

    public FileDocumentBasePage createFileDocument(String title, String description, boolean uploadBlob, String filePrefix, String fileSuffix, String fileContent) throws IOException {
        this.titleTextInput.sendKeys(new CharSequence[]{title});
        this.descriptionTextInput.sendKeys(new CharSequence[]{description});
        if (uploadBlob) {
            this.uploadBlob(filePrefix, fileSuffix, fileContent);
        }
        this.create();
        return this.asPage(FileDocumentBasePage.class);
    }

    protected FileWidgetElement getFileWidgetElement() {
        LayoutElement layout = new LayoutElement(this.driver, "document_create:nxl_file");
        return layout.getWidget("nxw_file:nxw_file_file", FileWidgetElement.class);
    }

    protected void uploadBlob(String filePrefix, String fileSuffix, String fileContent) throws IOException {
        FileWidgetElement fileWidget = this.getFileWidgetElement();
        fileWidget.uploadTestFile(filePrefix, fileSuffix, fileContent);
    }

    public FileCreationFormPage createFileDocumentWithoutTitle(String filePrefix, String fileSuffix, String fileContent) throws IOException {
        this.uploadBlob(filePrefix, fileSuffix, fileContent);
        this.create();
        return this.asPage(FileCreationFormPage.class);
    }

    public String getSelectedOption() {
        FileWidgetElement fileWidget = this.getFileWidgetElement();
        return fileWidget.getEditChoice();
    }

    public String getSelectedFilename() {
        FileWidgetElement fileWidget = this.getFileWidgetElement();
        return fileWidget.getFilename(true);
    }

    public String getSelectedFileErrorMessage() {
        LayoutElement layout = new LayoutElement(this.driver, "document_create:nxl_file");
        return layout.getSubElement("nxw_file:nxw_file_message").getText();
    }
}

