/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.functionaltests.pages.wizard;

import com.google.common.base.Function;
import org.nuxeo.functionaltests.pages.AbstractPage;
import org.nuxeo.functionaltests.pages.wizard.AbstractWizardPage;
import org.nuxeo.functionaltests.pages.wizard.IFrameHelper;
import org.openqa.selenium.By;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;

public class ConnectWizardPage
extends AbstractWizardPage {
    protected static final String REGISTER_DIV_LOCATOR = "//div[@class=\"CSS_CLASS\"]";

    public ConnectWizardPage(WebDriver driver) {
        super(driver);
        IFrameHelper.focusOnConnectFrame(driver);
    }

    @Override
    public String getTitle() {
        WebElement title = ConnectWizardPage.findElementWithTimeout(By.xpath((String)"//h3"));
        return title.getText().trim();
    }

    public void exitIframe() {
    }

    public String getErrorMessage() {
        WebElement el = ConnectWizardPage.findElementWithTimeout(By.cssSelector((String)"div.ui.warning.message"));
        if (el == null) {
            return null;
        }
        return el.getText().trim();
    }

    @Override
    protected String getNextButtonLocator() {
        return REGISTER_DIV_LOCATOR.replace("CSS_CLASS", "ui blue submit button btnNext");
    }

    @Override
    protected String getPreviousButtonLocator() {
        return REGISTER_DIV_LOCATOR.replace("CSS_CLASS", "ui blue submit button btnPrev");
    }

    public ConnectWizardPage getLink(String text) {
        ConnectWizardPage wpage = this.getLink(ConnectWizardPage.class, text);
        if (!this.driver.getCurrentUrl().contains("/register/")) {
            System.out.println("Oups, we are out of the frame !!!");
            this.driver.switchTo().frame("connectForm");
            return this.asPage(ConnectWizardPage.class);
        }
        return wpage;
    }

    public ConnectWizardPage submitWithError() {
        return this.next(ConnectWizardPage.class, new Function<WebDriver, Boolean>(){

            public Boolean apply(WebDriver input) {
                return ConnectWizardPage.this.findElementWithTimeout(By.cssSelector((String)".warning.message li"), 5000) != null;
            }
        });
    }

    public <T extends AbstractPage> T getLink(Class<T> wizardPageClass, String text) {
        WebElement link = ConnectWizardPage.findElementWithTimeout(By.linkText((String)text));
        if (link == null) {
            return null;
        }
        ConnectWizardPage.waitUntilEnabled(link);
        link.click();
        return (T)((AbstractPage)this.asPage(wizardPageClass));
    }

    public String getTitle2() {
        WebElement title2 = ConnectWizardPage.findElementWithTimeout(By.xpath((String)"//h2"));
        if (title2 == null) {
            return null;
        }
        return title2.getText();
    }
}

