/*
 * Decompiled with CFR 0.152.
 */
package fr.edu.lyon.nuxeo.operation;

import fr.edu.lyon.nuxeo.util.DocumentHelper;
import java.security.Principal;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.annotations.Param;
import org.nuxeo.ecm.automation.core.util.StringList;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.ecm.core.api.SystemPrincipal;
import org.nuxeo.ecm.core.api.impl.DocumentModelListImpl;
import org.nuxeo.ecm.platform.usermanager.UserManager;
import org.nuxeo.runtime.api.Framework;

@Operation(id="Context.FilterContextByPermission", category="Fetch", label="filter context by permissions", description="Filtre le contexte en \u00e9liminant les documents pour lesquels l'utilisateur courant ne poss\u00e8de aucune des permissions \u00e0 tester. La propri\u00e9t\u00e9 'permissions' doit \u00eatre renseign\u00e9e avec une liste de noms de permissions s\u00e9par\u00e9s par ','. Le param\u00e8tre useOriginationgUser n'est pas obligatoire, il permet de sp\u00e9cifier que l'op\u00e9ration doit utiliser le user originel (avant une \u00e9ventuelle identification syst\u00e8me) pour v\u00e9rifier les permissions. le param\u00e8tre user permet (si on utilise une session administrateur) de pr\u00e9ciser le user avec lequel les permissions doivent \u00eatre v\u00e9rifi\u00e9es. Renvoie une liste de documents")
public class FilterContextByPermission {
    public static final String ID = "Context.FilterContextByPermission";
    private static Log log = LogFactory.getLog(FilterContextByPermission.class);
    @Context
    private CoreSession session;
    @Param(name="permissions", required=true)
    private StringList permissions;
    @Param(name="useOriginatingUser", required=false, values={"false"})
    private boolean useOriginatingUser = false;
    @Param(name="user", required=false)
    private String userName;

    @OperationMethod
    public DocumentModelList run(DocumentModel doc) throws Exception {
        DocumentModelListImpl list = new DocumentModelListImpl();
        list.add((Object)doc);
        return this.run((DocumentModelList)list);
    }

    @OperationMethod
    public DocumentModelList run(DocumentModelList docs) throws Exception {
        log.debug((Object)(String.valueOf(docs.size()) + " document(s) en entr\u00e9e"));
        DocumentModelListImpl list = new DocumentModelListImpl();
        Principal principal = this.session.getPrincipal();
        if (this.useOriginatingUser && principal instanceof SystemPrincipal && ((SystemPrincipal)principal).getOriginatingUser() != null) {
            principal = this.getUserManager().getPrincipal(((SystemPrincipal)principal).getOriginatingUser());
        }
        if (this.userName != null && (principal instanceof SystemPrincipal || principal instanceof NuxeoPrincipal && ((NuxeoPrincipal)principal).isAdministrator())) {
            principal = this.getUserManager().getPrincipal(this.userName);
        }
        log.debug((Object)("Filtre appliqu\u00e9 dans le contexte du user : " + principal.getName()));
        list = DocumentHelper.filterListByPermission(this.session, principal, docs, (List<String>)this.permissions);
        log.debug((Object)(String.valueOf(list.size()) + " document(s) en sortie"));
        return list;
    }

    public UserManager getUserManager() throws Exception {
        UserManager userManager = (UserManager)Framework.getService(UserManager.class);
        if (userManager == null) {
            throw new Exception("unable to get userManager");
        }
        return userManager;
    }
}

