/*
 * Decompiled with CFR 0.152.
 */
package fr.edu.lyon.nuxeo.operation;

import java.util.HashSet;
import org.nuxeo.ecm.automation.OperationContext;
import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.annotations.Param;
import org.nuxeo.ecm.automation.core.util.StringList;
import org.nuxeo.ecm.automation.features.PrincipalHelper;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.security.PermissionProvider;
import org.nuxeo.ecm.platform.usermanager.UserManager;

@Operation(id="Document.GetGroups", category="Users & Groups", label="Groupes poss\u00e9dant la permission READ", description="Cette op\u00e9ration est une copie de l'op\u00e9ration Document.GetUsersAndGroups modulo les sp\u00e9cificit\u00e9s suivantes : seuls les groupes sont r\u00e9cup\u00e9r\u00e9s ; l'op\u00e9ration fonctionne sur les listes de document")
public class GetDocumentsGroups {
    public static final String ID = "Document.GetGroups";
    @Context
    protected PermissionProvider permissionProvider;
    @Context
    protected UserManager umgr;
    @Context
    protected OperationContext ctx;
    @Param(name="permission")
    protected String permission;
    @Param(name="variable name")
    protected String key;

    @OperationMethod
    public DocumentModelList run(DocumentModelList input) throws Exception {
        PrincipalHelper ph = new PrincipalHelper(this.umgr, this.permissionProvider);
        HashSet result = new HashSet();
        for (DocumentModel doc : input) {
            result.addAll(ph.getUserAndGroupIdsForPermission(doc, this.permission, false, false, false));
        }
        this.ctx.put(this.key, (Object)new StringList(result));
        return input;
    }
}

