/*
 * Decompiled with CFR 0.152.
 */
package fr.edu.lyon.nuxeo.operation;

import java.security.Principal;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.automation.OperationContext;
import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.annotations.Param;
import org.nuxeo.ecm.automation.core.collectors.DocumentModelListCollector;
import org.nuxeo.ecm.automation.core.util.StringList;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.DocumentSecurityException;
import org.nuxeo.ecm.core.api.UnrestrictedSessionRunner;
import org.nuxeo.ecm.core.api.impl.DocumentModelListImpl;
import org.nuxeo.ecm.core.api.security.ACE;
import org.nuxeo.ecm.core.api.security.ACL;
import org.nuxeo.ecm.core.api.security.ACP;
import org.nuxeo.ecm.core.api.security.impl.ACLImpl;
import org.nuxeo.ecm.core.api.security.impl.ACPImpl;

@Operation(id="Document.UnrestrictedDiffusion", category="Document", label="Diffuse document", description="Publie le(s) document(s) du contexte d'entr\u00e9e dans un ensemble de sections. le 'diffuseur' doit poss\u00e9der une permission (pass\u00e9e en param\u00e8tre) sur le(s) document(s) source(s) ; les cibles peuvent \u00eatre renseign\u00e9es de le m\u00eame fa\u00e7on que dans l'op\u00e9ration MultiPublishDocument... L'op\u00e9ration retourne tous les proxies du document en entr\u00e9e")
public class UnrestrictedDiffusion {
    public static final String ID = "Document.UnrestrictedDiffusion";
    private static Log log = LogFactory.getLog(UnrestrictedDiffusion.class);
    @Context
    private CoreSession session;
    @Param(name="operationPermissions", required=true)
    private StringList operationPermissions;
    @Param(name="target")
    protected DocumentModelList targets;
    @Param(name="override", required=false, values={"true"})
    protected boolean override = true;
    @Param(name="rightGroups", required=false)
    protected StringList rightGroups;
    @Context
    protected OperationContext ctx;

    @OperationMethod(collector=DocumentModelListCollector.class)
    public DocumentModelList run(DocumentModel doc) throws Exception {
        UnrestrictedPublisher publisher = new UnrestrictedPublisher(this.session, this.session.getPrincipal(), doc, this.targets);
        publisher.runUnrestricted();
        return publisher.proxies;
    }

    private class UnrestrictedPublisher
    extends UnrestrictedSessionRunner {
        DocumentModel docToPublish;
        Principal principal;
        DocumentModelList proxies;
        List<String> errors;

        public UnrestrictedPublisher(CoreSession session, Principal originalPrincipal, DocumentModel docToPublish, DocumentModelList targets) {
            super(session);
            this.docToPublish = docToPublish;
            this.principal = originalPrincipal;
        }

        public void run() throws ClientException {
            this.checkPermission(this.docToPublish, "Read");
            this.errors = new ArrayList<String>();
            this.proxies = new DocumentModelListImpl();
            for (DocumentModel target : UnrestrictedDiffusion.this.targets) {
                if (!this.checkOperationPermissions()) continue;
                this.publishDocumentIn(target);
            }
            if (!this.errors.isEmpty()) {
                StringBuilder sb = new StringBuilder();
                sb.append("La diffusion dans les sections");
                for (String error : this.errors) {
                    sb.append(error);
                    sb.append(", ");
                }
                sb.append("n'a pas \u00e9t\u00e9 possible : privil\u00e8ges insuffisant");
                UnrestrictedDiffusion.this.ctx.put("Seam.AddInfoMessage", (Object)sb.toString());
            }
            this.proxies = this.session.getProxies(this.docToPublish.getRef(), null);
            if (UnrestrictedDiffusion.this.rightGroups != null && UnrestrictedDiffusion.this.rightGroups.size() > 0) {
                this.setACE(this.proxies);
            }
        }

        private final boolean checkOperationPermissions() throws ClientException {
            for (String permission : UnrestrictedDiffusion.this.operationPermissions) {
                if (!this.session.hasPermission(this.docToPublish.getRef(), permission)) continue;
                return true;
            }
            return false;
        }

        private final void publishDocumentIn(DocumentModel target) throws ClientException {
            DocumentRef targetRef = target.getRef();
            if (this.session.hasPermission(this.principal, targetRef, "AddChildren")) {
                this.session.publishDocument(this.docToPublish, target, UnrestrictedDiffusion.this.override);
                log.debug((Object)("Publication de " + this.docToPublish.getPathAsString() + " dans " + target.getPathAsString()));
            } else {
                DocumentModelList proxies = this.session.getProxies(this.docToPublish.getRef(), target.getRef());
                boolean goodProxy = false;
                for (DocumentModel proxy : proxies) {
                    if (goodProxy || !targetRef.equals(proxy.getParentRef())) continue;
                    goodProxy = true;
                    this.session.publishDocument(this.docToPublish, target, UnrestrictedDiffusion.this.override);
                    log.debug((Object)("Maj de la publication de " + this.docToPublish.getPathAsString() + " dans " + target.getPathAsString()));
                }
                if (!goodProxy) {
                    log.warn((Object)("Le privilege 'AddChildren' n'est pas accord\u00e9 \u00e0 '" + this.principal.getName() + "' sur " + target.getPathAsString()));
                    this.errors.add(target.getPathAsString());
                }
            }
        }

        private final void checkPermission(DocumentModel doc, String permission) throws ClientException {
            if (!this.session.hasPermission(this.principal, doc.getRef(), permission)) {
                log.error((Object)("Le privilege '" + permission + "' n'est pas accord\u00e9 \u00e0 '" + this.principal.getName() + "' sur " + doc.getPathAsString()));
                throw new DocumentSecurityException(String.valueOf(this.principal.getName()) + "' n'a pas les privil\u00e8ges requis sur " + doc.getPathAsString() + " pour publier " + this.docToPublish.getPathAsString());
            }
        }

        private final void setACE(DocumentModel doc, String rightGroup) throws ClientException {
            ACPImpl acp = new ACPImpl();
            ACLImpl acl = new ACLImpl("local");
            acp.addACL((ACL)acl);
            log.debug((Object)("d\u00e9finition de la permission Read sur le document " + doc + " pour le groupe " + rightGroup));
            ACE ace = new ACE(rightGroup, "Read", true);
            acl.add((Object)ace);
            this.session.setACP(doc.getRef(), (ACP)acp, false);
        }

        private final void setACE(DocumentModel doc) throws ClientException {
            for (String permission : UnrestrictedDiffusion.this.rightGroups) {
                this.setACE(doc, permission);
            }
        }

        private final void setACE(DocumentModelList docs) throws ClientException {
            for (DocumentModel doc : docs) {
                this.setACE(doc);
            }
        }
    }
}

