/*
 * Decompiled with CFR 0.152.
 */
package fr.edu.lyon.nuxeo.util;

import java.io.Serializable;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.core.api.PathRef;
import org.nuxeo.ecm.core.api.impl.DocumentModelListImpl;
import org.nuxeo.ecm.core.api.model.PropertyException;

public class DocumentHelper {
    private static Log log = LogFactory.getLog(DocumentHelper.class);

    public static DocumentModelList getDocumentListFromPathProperty(CoreSession session, DocumentModel doc, String property) throws PropertyException, ClientException {
        Serializable value = doc.getPropertyValue(property);
        String[] paths = new String[]{};
        boolean parseValue = true;
        if (value instanceof String) {
            paths = new String[]{(String)((Object)value)};
        } else if (value instanceof String[]) {
            paths = (String[])value;
        } else if (value instanceof Collection) {
            Collection pathCollection = (Collection)((Object)value);
            if (!pathCollection.isEmpty()) {
                Object el = pathCollection.iterator().next();
                if (el instanceof String) {
                    paths = pathCollection.toArray(new String[pathCollection.size()]);
                } else {
                    parseValue = false;
                }
            }
        } else {
            parseValue = false;
        }
        if (!parseValue) {
            throw new ClientException("la propri\u00e9t\u00e9 " + property + " n'est pas utilisable par ce helper");
        }
        DocumentModelListImpl list = new DocumentModelListImpl();
        String[] stringArray = paths;
        int n = paths.length;
        int n2 = 0;
        while (n2 < n) {
            String path = stringArray[n2];
            try {
                DocumentModel docFromPath = session.getDocument((DocumentRef)new PathRef(path));
                log.debug((Object)("document " + docFromPath + " identifi\u00e9"));
                list.add((Object)docFromPath);
            }
            catch (ClientException e) {
                log.warn((Object)(String.valueOf(e.getMessage()) + "-> acc\u00e8s via " + path + " depuis " + doc.getPathAsString() + " - " + property));
            }
            ++n2;
        }
        return list;
    }

    public static DocumentModelList filterListByPermission(CoreSession session, Principal principal, DocumentModelList docs, List<String> permissions) throws ClientException {
        DocumentModelListImpl result = new DocumentModelListImpl();
        log.debug((Object)("Filtre appliqu\u00e9 dans le contexte du user : " + principal.getName()));
        for (DocumentModel doc : docs) {
            boolean insert = false;
            for (String permission : permissions) {
                if (insert || !session.hasPermission(principal, (DocumentRef)new IdRef(doc.getId()), permission)) continue;
                result.add((Object)doc);
                log.debug((Object)("Le principal (" + principal.getName() + " poss\u00e8de la permission " + permission + " sur le document " + doc.getPath()));
                insert = true;
            }
        }
        return result;
    }

    public static DocumentModelList filterListByPermission(CoreSession session, Principal principal, DocumentModelList docs, String permission) throws ClientException {
        ArrayList<String> permissions = new ArrayList<String>();
        permissions.add(permission);
        return DocumentHelper.filterListByPermission(session, principal, docs, permissions);
    }
}

