/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.binary.metadata.internals;

import java.io.Serializable;
import java.util.List;
import org.nuxeo.binary.metadata.api.BinaryMetadataService;
import org.nuxeo.binary.metadata.internals.MetadataMappingUpdate;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.core.work.AbstractWork;
import org.nuxeo.ecm.core.work.api.Work;
import org.nuxeo.runtime.api.Framework;

public class BinaryMetadataUpdateWork
extends AbstractWork {
    private static final long serialVersionUID = 1L;
    protected static final String BINARY_METADATA_WORK = "binary_metadata_work";
    protected static final String BINARY_METADATA_WORK_TITLE = "Binary Metadata Update Worker";
    protected final List<MetadataMappingUpdate> metadataUpdates;

    public BinaryMetadataUpdateWork(String repositoryName, String docId, List<MetadataMappingUpdate> metadataUpdates) {
        super("BinaryMetadataUpdate|docId=" + docId);
        this.setDocument(repositoryName, docId);
        this.metadataUpdates = metadataUpdates;
    }

    public String getCategory() {
        return BINARY_METADATA_WORK;
    }

    public String getTitle() {
        return BINARY_METADATA_WORK_TITLE;
    }

    public boolean isIdempotent() {
        return false;
    }

    public void work() {
        this.setProgress(Work.Progress.PROGRESS_INDETERMINATE);
        this.setStatus("Updating Metadata");
        this.openSystemSession();
        if (!this.session.exists((DocumentRef)new IdRef(this.docId))) {
            this.setStatus("Nothing to process");
            return;
        }
        BinaryMetadataService binaryMetadataService = (BinaryMetadataService)Framework.getService(BinaryMetadataService.class);
        DocumentModel workingDocument = this.session.getDocument((DocumentRef)new IdRef(this.docId));
        binaryMetadataService.applyUpdates(workingDocument, this.metadataUpdates);
        workingDocument.putContextData("disableBinaryMetadataListener", (Serializable)Boolean.TRUE);
        workingDocument.putContextData("DisableAutoCheckOut", (Serializable)Boolean.TRUE);
        workingDocument.putContextData("DisableAutomaticVersioning", (Serializable)Boolean.TRUE);
        workingDocument.putContextData("disableAuditLogger", (Serializable)Boolean.TRUE);
        workingDocument.putContextData("disableDublinCoreListener", (Serializable)Boolean.TRUE);
        workingDocument.putContextData("disableNotificationService", (Serializable)Boolean.TRUE);
        workingDocument.putContextData("disablePictureViewsGenerationListener", (Serializable)Boolean.TRUE);
        workingDocument.putContextData("disableThumbnailComputation", (Serializable)Boolean.TRUE);
        workingDocument.putContextData("disableVideoConversionsGenerationListener", (Serializable)Boolean.TRUE);
        this.session.saveDocument(workingDocument);
        this.setStatus("Metadata Update Done");
    }
}

