/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.binary.metadata.internals.listeners;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.naming.NamingException;
import javax.transaction.RollbackException;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.TransactionManager;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.nuxeo.binary.metadata.api.BinaryMetadataService;
import org.nuxeo.binary.metadata.internals.BinaryMetadataUpdateWork;
import org.nuxeo.binary.metadata.internals.MetadataMappingUpdate;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.event.Event;
import org.nuxeo.ecm.core.event.EventContext;
import org.nuxeo.ecm.core.event.EventListener;
import org.nuxeo.ecm.core.event.impl.DocumentEventContext;
import org.nuxeo.ecm.core.work.api.WorkManager;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.transaction.TransactionHelper;

public class BinaryMetadataSyncListener
implements EventListener,
Synchronization {
    private static final Logger log = LogManager.getLogger(BinaryMetadataSyncListener.class);
    protected static final ThreadLocal<Boolean> IS_ENLISTED = ThreadLocal.withInitial(() -> Boolean.FALSE);
    protected static final ThreadLocal<List<DocumentMetadataMappingUpdates>> TRANSACTION_UPDATES = ThreadLocal.withInitial(ArrayList::new);

    public void handleEvent(Event event) {
        List<MetadataMappingUpdate> asyncUpdates;
        String eventName = event.getName();
        EventContext ctx = event.getContext();
        if (!(ctx instanceof DocumentEventContext)) {
            return;
        }
        boolean creation = "aboutToCreate".equals(eventName) || "documentCreated".equals(eventName);
        boolean update = "beforeDocumentModification".equals(eventName);
        if (!creation && !update) {
            return;
        }
        DocumentModel doc = ((DocumentEventContext)ctx).getSourceDocument();
        if (doc.isProxy() || doc.isVersion() || BooleanUtils.isTrue((Boolean)((Boolean)ctx.getProperty("disableBinaryMetadataListener")))) {
            return;
        }
        if (!IS_ENLISTED.get().booleanValue()) {
            IS_ENLISTED.set(this.registerSynchronization(this));
        }
        BinaryMetadataService binaryMetadataService = (BinaryMetadataService)Framework.getService(BinaryMetadataService.class);
        Map<Boolean, List<MetadataMappingUpdate>> metadataUpdates = binaryMetadataService.getMetadataUpdates(doc, creation).stream().collect(Collectors.partitioningBy(MetadataMappingUpdate::isAsync));
        if ("aboutToCreate".equals(eventName) || "beforeDocumentModification".equals(eventName)) {
            binaryMetadataService.applyUpdates(doc, metadataUpdates.get(Boolean.FALSE));
        }
        if (("documentCreated".equals(eventName) || "beforeDocumentModification".equals(eventName)) && !(asyncUpdates = metadataUpdates.get(Boolean.TRUE)).isEmpty()) {
            TRANSACTION_UPDATES.get().add(new DocumentMetadataMappingUpdates(doc, asyncUpdates));
        }
    }

    public void beforeCompletion() {
    }

    public void afterCompletion(int status) {
        try {
            if (1 == status || 4 == status) {
                return;
            }
            WorkManager workManager = (WorkManager)Framework.getService(WorkManager.class);
            TRANSACTION_UPDATES.get().stream().map(tu -> new BinaryMetadataUpdateWork(tu.doc.getRepositoryName(), tu.doc.getId(), tu.updates)).forEach(arg_0 -> ((WorkManager)workManager).schedule(arg_0));
        }
        finally {
            IS_ENLISTED.set(Boolean.FALSE);
            TRANSACTION_UPDATES.get().clear();
        }
    }

    protected boolean registerSynchronization(Synchronization sync) {
        try {
            TransactionManager tm = TransactionHelper.lookupTransactionManager();
            if (tm.getTransaction() != null) {
                tm.getTransaction().registerSynchronization(sync);
                return true;
            }
            if (!Framework.isTestModeSet()) {
                log.error("Unable to register synchronization : no active transaction");
            }
            return false;
        }
        catch (IllegalStateException | NamingException | RollbackException | SystemException e) {
            log.error("Unable to register synchronization", e);
            return false;
        }
    }

    protected static class DocumentMetadataMappingUpdates {
        protected final DocumentModel doc;
        protected final List<MetadataMappingUpdate> updates;

        public DocumentMetadataMappingUpdates(DocumentModel doc, List<MetadataMappingUpdate> updates) {
            this.doc = doc;
            this.updates = updates;
        }
    }
}

