/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.core;

import com.google.inject.Inject;
import java.io.Serializable;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.nuxeo.ecm.automation.AutomationService;
import org.nuxeo.ecm.automation.OperationChain;
import org.nuxeo.ecm.automation.OperationContext;
import org.nuxeo.ecm.automation.test.AutomationFeature;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.impl.blob.StringBlob;
import org.nuxeo.ecm.core.test.CoreFeature;
import org.nuxeo.ecm.core.test.FakeSmtpMailServerFeature;
import org.nuxeo.runtime.test.runner.Deploy;
import org.nuxeo.runtime.test.runner.Features;
import org.nuxeo.runtime.test.runner.FeaturesRunner;

@RunWith(value=FeaturesRunner.class)
@Features(value={CoreFeature.class, FakeSmtpMailServerFeature.class, AutomationFeature.class})
@Deploy(value={"org.nuxeo.ecm.platform.notification.core", "org.nuxeo.ecm.platform.notification.api", "org.nuxeo.ecm.platform.url.api", "org.nuxeo.ecm.platform.url.core"})
public class SendMailTest {
    protected DocumentModel src;
    @Inject
    AutomationService service;
    @Inject
    CoreSession session;

    @Before
    public void initRepo() throws Exception {
        this.session.removeChildren(this.session.getRootDocument().getRef());
        this.session.save();
        this.src = this.session.createDocumentModel("/", "src", "File");
        this.src.setPropertyValue("dc:title", (Serializable)((Object)"Source"));
        this.src = this.session.createDocument(this.src);
        this.session.save();
        this.src = this.session.getDocument(this.src.getRef());
    }

    @Test
    @Ignore
    public void testSendMail() throws Exception {
        StringBlob blob = new StringBlob("my content");
        blob.setMimeType("text/plain");
        blob.setEncoding("UTF-8");
        blob.setFilename("thefile.txt");
        OperationContext ctx = new OperationContext(this.session);
        ctx.setInput((Object)this.src);
        OperationChain chain = new OperationChain("sendEMail");
        chain.add("Context.FetchDocument");
        chain.add("Blob.Set").set("file", (Object)blob);
        chain.add("Notification.SendMail").set("from", (Object)"test@nuxeo.org").set("to", (Object)"bs@nuxeo.com").set("subject", (Object)"test mail").set("asHTML", (Object)true).set("files", (Object)"file:content").set("message", (Object)"<h3>Current doc: ${Document.path}</h3> title: ${Document['dc:title']}<p>Doc link: <a href=\"${docUrl}\">${Document.title}</a>");
        this.service.run(ctx, chain);
        Assert.assertTrue((FakeSmtpMailServerFeature.server.getReceivedEmailSize() == 1 ? 1 : 0) != 0);
    }
}

