/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.server.test;

import com.google.inject.Inject;
import java.io.FileInputStream;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryUsage;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.nuxeo.ecm.automation.client.Session;
import org.nuxeo.ecm.automation.server.test.UploadFileSupport;
import org.nuxeo.ecm.automation.test.EmbeddedAutomationServerFeature;
import org.nuxeo.runtime.test.runner.Features;
import org.nuxeo.runtime.test.runner.FeaturesRunner;
import org.nuxeo.runtime.test.runner.Jetty;

@RunWith(value=FeaturesRunner.class)
@Features(value={EmbeddedAutomationServerFeature.class})
@Jetty(port=18080)
public class UploadBigFileTest {
    @Inject
    Session session;

    @Test
    public void withMaxMemory() throws Exception {
        MemoryMXBean mbean = ManagementFactory.getMemoryMXBean();
        MemoryUsage usage = mbean.getHeapMemoryUsage();
        UploadFileSupport.MockInputStream source = UploadFileSupport.newMockInput(usage.getMax(), false);
        FileInputStream result = new UploadFileSupport(this.session, "/").testUploadFile(source);
        Assert.assertEquals((long)source.consumed, (long)result.getChannel().size());
    }
}

