/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.xml.transform;

import com.phloc.commons.error.EErrorLevel;
import com.phloc.commons.error.IResourceError;
import com.phloc.commons.error.IResourceLocation;
import com.phloc.commons.error.ResourceError;
import com.phloc.commons.error.ResourceLocation;
import com.phloc.commons.name.IHasDisplayText;
import com.phloc.commons.string.StringHelper;
import com.phloc.commons.string.ToStringGenerator;
import com.phloc.commons.xml.transform.EXMLTransformTexts;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.SourceLocator;
import javax.xml.transform.TransformerException;

public abstract class AbstractTransformErrorListener
implements ErrorListener {
    private final ErrorListener m_aWrappedErrorListener;

    public AbstractTransformErrorListener() {
        this(null);
    }

    public AbstractTransformErrorListener(@Nullable ErrorListener errorListener) {
        this.m_aWrappedErrorListener = errorListener;
    }

    @Nullable
    public ErrorListener getWrappedErrorListener() {
        return this.m_aWrappedErrorListener;
    }

    @Nonnull
    private static IResourceError _buildError(@Nonnull TransformerException transformerException, @Nonnull EErrorLevel eErrorLevel, @Nonnull IHasDisplayText iHasDisplayText) {
        SourceLocator sourceLocator = transformerException.getLocator();
        String string = sourceLocator == null ? null : StringHelper.getConcatenatedOnDemand(sourceLocator.getPublicId(), "/", sourceLocator.getSystemId());
        ResourceLocation resourceLocation = new ResourceLocation(string, sourceLocator != null ? sourceLocator.getLineNumber() : -1, sourceLocator != null ? sourceLocator.getColumnNumber() : -1);
        return new ResourceError((IResourceLocation)resourceLocation, eErrorLevel, iHasDisplayText, (Throwable)transformerException);
    }

    protected abstract void internalLog(@Nonnull IResourceError var1);

    @Override
    public final void warning(@Nonnull TransformerException transformerException) throws TransformerException {
        this.internalLog(AbstractTransformErrorListener._buildError(transformerException, EErrorLevel.WARN, EXMLTransformTexts.TRANSFORMATION_WARNING));
        if (this.m_aWrappedErrorListener != null) {
            this.m_aWrappedErrorListener.warning(transformerException);
        }
    }

    @Override
    public final void error(@Nonnull TransformerException transformerException) throws TransformerException {
        this.internalLog(AbstractTransformErrorListener._buildError(transformerException, EErrorLevel.ERROR, EXMLTransformTexts.TRANSFORMATION_ERROR));
        if (this.m_aWrappedErrorListener != null) {
            this.m_aWrappedErrorListener.error(transformerException);
        }
    }

    @Override
    public final void fatalError(@Nonnull TransformerException transformerException) throws TransformerException {
        this.internalLog(AbstractTransformErrorListener._buildError(transformerException, EErrorLevel.FATAL_ERROR, EXMLTransformTexts.TRANSFORMATION_FATAL_ERROR));
        if (this.m_aWrappedErrorListener != null) {
            this.m_aWrappedErrorListener.fatalError(transformerException);
        }
    }

    public String toString() {
        return new ToStringGenerator(this).appendIfNotNull("wrappedListener", this.m_aWrappedErrorListener).toString();
    }
}

