/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.directory.memory;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.nuxeo.ecm.directory.Directory;
import org.nuxeo.ecm.directory.DirectoryException;
import org.nuxeo.ecm.directory.DirectoryFactory;
import org.nuxeo.ecm.directory.api.DirectoryService;
import org.nuxeo.ecm.directory.memory.MemoryDirectory;
import org.nuxeo.runtime.api.Framework;

public class MemoryDirectoryFactory
implements DirectoryFactory {
    private final Map<String, MemoryDirectory> directories = new HashMap<String, MemoryDirectory>();
    private final DirectoryService directoryService;

    public MemoryDirectoryFactory() throws DirectoryException {
        try {
            this.directoryService = (DirectoryService)Framework.getService(DirectoryService.class);
        }
        catch (Exception e) {
            throw new DirectoryException("Error in Directory Service lookup", (Throwable)e);
        }
    }

    public String getName() {
        return "memdirs";
    }

    public void registerDirectory(MemoryDirectory directory) {
        String directoryName = directory.getName();
        this.directories.put(directoryName, directory);
        this.directoryService.registerDirectory(directoryName, (DirectoryFactory)this);
    }

    public void unregisterDirectory(MemoryDirectory directory) {
        String directoryName = directory.getName();
        this.directoryService.unregisterDirectory(directoryName, (DirectoryFactory)this);
        this.directories.remove(directoryName);
    }

    public Directory getDirectory(String name) {
        return this.directories.get(name);
    }

    public void shutdown() {
    }

    public List<Directory> getDirectories() {
        return new ArrayList<Directory>(this.directories.values());
    }
}

