/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.spatial.prefix;

import com.spatial4j.core.shape.Shape;
import org.apache.lucene.search.Filter;
import org.apache.lucene.spatial.DisjointSpatialFilter;
import org.apache.lucene.spatial.prefix.ContainsPrefixTreeFilter;
import org.apache.lucene.spatial.prefix.IntersectsPrefixTreeFilter;
import org.apache.lucene.spatial.prefix.PrefixTreeStrategy;
import org.apache.lucene.spatial.prefix.WithinPrefixTreeFilter;
import org.apache.lucene.spatial.prefix.tree.SpatialPrefixTree;
import org.apache.lucene.spatial.query.SpatialArgs;
import org.apache.lucene.spatial.query.SpatialOperation;
import org.apache.lucene.spatial.query.UnsupportedSpatialOperation;

public class RecursivePrefixTreeStrategy
extends PrefixTreeStrategy {
    private int prefixGridScanLevel;
    protected boolean pointsOnly = false;
    protected boolean multiOverlappingIndexedShapes = true;

    public RecursivePrefixTreeStrategy(SpatialPrefixTree grid, String fieldName) {
        super(grid, fieldName, true);
        this.prefixGridScanLevel = grid.getMaxLevels() - 4;
    }

    public void setPrefixGridScanLevel(int prefixGridScanLevel) {
        this.prefixGridScanLevel = prefixGridScanLevel;
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "(prefixGridScanLevel:" + this.prefixGridScanLevel + ",SPG:(" + this.grid + "))";
    }

    @Override
    public Filter makeFilter(SpatialArgs args) {
        SpatialOperation op = args.getOperation();
        if (op == SpatialOperation.IsDisjointTo) {
            return new DisjointSpatialFilter(this, args, this.getFieldName());
        }
        Shape shape = args.getShape();
        int detailLevel = this.grid.getLevelForDistance(args.resolveDistErr(this.ctx, this.distErrPct));
        if (this.pointsOnly || op == SpatialOperation.Intersects) {
            return new IntersectsPrefixTreeFilter(shape, this.getFieldName(), this.grid, detailLevel, this.prefixGridScanLevel, !this.pointsOnly);
        }
        if (op == SpatialOperation.IsWithin) {
            return new WithinPrefixTreeFilter(shape, this.getFieldName(), this.grid, detailLevel, this.prefixGridScanLevel, -1.0);
        }
        if (op == SpatialOperation.Contains) {
            return new ContainsPrefixTreeFilter(shape, this.getFieldName(), this.grid, detailLevel, this.multiOverlappingIndexedShapes);
        }
        throw new UnsupportedSpatialOperation(op);
    }
}

