/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.rendition.service;

import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.UnrestrictedSessionRunner;

public class RenditionFinder
extends UnrestrictedSessionRunner {
    protected final DocumentModel source;
    protected DocumentModel storedRendition;
    protected final String definitionName;

    protected RenditionFinder(DocumentModel source, String definitionName) {
        super(source.getCoreSession());
        this.source = source;
        this.definitionName = definitionName;
    }

    public void run() throws ClientException {
        String query = "select * from Document where ecm:isProxy = 0 AND  ecm:isCheckedInVersion = 1 AND ";
        query = query + "rend:renditionName" + "='" + this.definitionName + "' AND ";
        String versionUUUID = this.source.getId();
        if (!this.source.isVersion() && !this.source.isCheckedOut()) {
            versionUUUID = this.session.getLastDocumentVersion(this.source.getRef()).getId();
        }
        query = query + "rend:sourceId" + "='" + versionUUUID + "' ";
        DocumentModelList docs = this.session.query(query = query + " order by dc:modified desc ");
        if (docs.size() > 0) {
            this.storedRendition = (DocumentModel)docs.get(0);
            this.storedRendition.detach(true);
        }
    }

    public DocumentModel getStoredRendition() {
        return this.storedRendition;
    }
}

