/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.server.jaxrs.batch;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.nuxeo.common.utils.FileUtils;
import org.nuxeo.common.utils.Path;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.impl.blob.FileBlob;

public class Batch {
    protected Map<String, Blob> uploadedBlob = new ConcurrentHashMap<String, Blob>();
    protected final String id;
    protected final String baseDir;
    protected final AtomicInteger uploadInProgress = new AtomicInteger(0);

    public Batch(String id) {
        this.id = id;
        File tmpDir = new File(System.getProperty("java.io.tmpdir"));
        this.baseDir = new Path(tmpDir.getPath()).append(id).toString();
        File file = new File(this.baseDir);
        try {
            if (!file.getCanonicalPath().startsWith(tmpDir.getCanonicalPath())) {
                throw new SecurityException("Trying to traverse illegal path");
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Error when trying to create Batch", e);
        }
        file.mkdirs();
    }

    public void addBlob(String idx, Blob blob) {
        this.uploadedBlob.put(idx, blob);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addStream(String idx, InputStream is, String name, String mime) throws IOException {
        this.uploadInProgress.incrementAndGet();
        try {
            File tmp = new File(new Path(this.baseDir).append(String.valueOf(System.nanoTime())).toString());
            FileUtils.copyToFile((InputStream)is, (File)tmp);
            FileBlob blob = new FileBlob(tmp);
            if (mime != null) {
                blob.setMimeType(mime);
            } else {
                blob.setMimeType("application/octet-stream");
            }
            blob.setFilename(name);
            this.addBlob(idx, (Blob)blob);
        }
        finally {
            this.uploadInProgress.decrementAndGet();
        }
    }

    public List<Blob> getBlobs() {
        return this.getBlobs(0);
    }

    public List<Blob> getBlobs(int timeoutS) {
        ArrayList<Blob> blobs = new ArrayList<Blob>();
        if (this.uploadInProgress.get() > 0 && timeoutS > 0) {
            for (int i = 0; i < timeoutS * 5; ++i) {
                try {
                    Thread.sleep(200L);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
                if (this.uploadInProgress.get() == 0) break;
            }
        }
        ArrayList<String> sortedIdx = new ArrayList<String>(this.uploadedBlob.keySet());
        Collections.sort(sortedIdx);
        for (String k : sortedIdx) {
            blobs.add(this.uploadedBlob.get(k));
        }
        return blobs;
    }

    public Blob getBlob(String fileId) {
        return this.getBlob(fileId, 0);
    }

    public Blob getBlob(String fileId, int timeoutS) {
        Blob result = this.uploadedBlob.get(fileId);
        if (result == null && timeoutS > 0 && this.uploadInProgress.get() > 0) {
            for (int i = 0; i < timeoutS * 5; ++i) {
                try {
                    Thread.sleep(200L);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
                result = this.uploadedBlob.get(fileId);
                if (result != null) break;
            }
        }
        return result;
    }

    public void clear() {
        this.uploadedBlob.clear();
        FileUtils.deleteTree((File)new File(this.baseDir));
    }
}

