/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.functionaltests;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class WaitUntil {
    public static final Log log = LogFactory.getLog(WaitUntil.class);
    long timeout;

    public WaitUntil(long timeout) {
        this.timeout = timeout;
    }

    public WaitUntil() {
        this.timeout = 2000L;
    }

    public void waitUntil() {
        long starttime = System.currentTimeMillis();
        Exception lastException = null;
        while (starttime > System.currentTimeMillis() - this.timeout) {
            try {
                if (this.condition()) {
                    return;
                }
                Thread.sleep(100L);
                lastException = null;
            }
            catch (Exception e) {
                log.warn((Object)"An exception while testing condition", (Throwable)e);
                lastException = e;
            }
        }
        throw new RuntimeException("Couldn't find element", lastException);
    }

    public abstract boolean condition();
}

