/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.functionaltests.fragment;

import org.nuxeo.functionaltests.AbstractTest;
import org.nuxeo.functionaltests.AjaxRequestManager;
import org.nuxeo.functionaltests.Locator;
import org.nuxeo.functionaltests.forms.Select2WidgetElement;
import org.nuxeo.functionaltests.fragment.WebFragmentImpl;
import org.nuxeo.functionaltests.pages.DocumentBasePage;
import org.openqa.selenium.By;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;

public class AddToCollectionForm
extends WebFragmentImpl {
    private static final String ADD_BUTTON_ID = "nxw_addToCollectionAction_after_view_fancy_subview:nxw_addToCollectionAction_after_view_fancyform:add";
    private static final String S2_CHOOSE_COLLECTION_ID = "s2id_nxw_addToCollectionAction_after_view_fancy_subview:nxw_addToCollectionAction_after_view_fancyform:nxw_singleDocumentSuggestion_1_select2";
    private static final String NEW_COLLECTION_DESCRIPTION_ID = "nxw_addToCollectionAction_after_view_fancy_subview:nxw_addToCollectionAction_after_view_fancyform:description";
    private static final String EXISTING_COLLECTION_DESCRIPTION_ID = "nxw_addToCollectionAction_after_view_fancy_subview:nxw_addToCollectionAction_after_view_fancyform:scd";
    protected boolean multiple = false;

    public AddToCollectionForm(WebDriver driver, WebElement element) {
        super(driver, element);
    }

    protected boolean isMultiple() {
        return this.multiple;
    }

    public DocumentBasePage add() {
        return this.add(DocumentBasePage.class);
    }

    public <T> T add(Class<T> pageClassProxy) {
        Locator.findElementWaitUntilEnabledAndClick(By.id((String)ADD_BUTTON_ID));
        return AbstractTest.asPage(pageClassProxy);
    }

    protected String getAddButtonId() {
        return ADD_BUTTON_ID;
    }

    protected String getChooseCollectionId() {
        return S2_CHOOSE_COLLECTION_ID;
    }

    protected String getNewCollectionDescriptionId() {
        return NEW_COLLECTION_DESCRIPTION_ID;
    }

    protected String getCollectionDescriptionId() {
        return EXISTING_COLLECTION_DESCRIPTION_ID;
    }

    public void setCollection(String collectionName) {
        Locator.findElementAndWaitUntilEnabled(By.id((String)this.getChooseCollectionId()));
        Select2WidgetElement s2Collection = new Select2WidgetElement(this.driver, this.getChooseCollectionId());
        AjaxRequestManager arm = new AjaxRequestManager(this.driver);
        arm.begin();
        s2Collection.selectValue(collectionName, false, true);
        arm.end();
        Locator.findElementAndWaitUntilEnabled(By.id((String)this.getAddButtonId()));
    }

    public void setNewDescription(String collectionDescription) {
        Locator.findElementAndWaitUntilEnabled(By.id((String)this.getNewCollectionDescriptionId())).sendKeys(new CharSequence[]{collectionDescription});
    }

    public boolean isNewDescriptionVisible() {
        try {
            this.driver.findElement(By.id((String)this.getNewCollectionDescriptionId()));
            return true;
        }
        catch (NoSuchElementException e) {
            return false;
        }
    }

    public boolean isExistingDescriptionVisible() {
        try {
            this.driver.findElement(By.id((String)this.getCollectionDescriptionId()));
            return true;
        }
        catch (NoSuchElementException e) {
            return false;
        }
    }

    public String getExistingDescription() {
        return this.driver.findElement(By.id((String)this.getCollectionDescriptionId())).getText();
    }
}

