/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.restapi.server.jaxrs.search;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.EnumUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.automation.core.util.PageProviderHelper;
import org.nuxeo.ecm.automation.jaxrs.io.documents.PaginableDocumentModelListImpl;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.api.SortInfo;
import org.nuxeo.ecm.platform.query.api.PageProviderDefinition;
import org.nuxeo.ecm.platform.query.api.PageProviderService;
import org.nuxeo.ecm.platform.query.api.QuickFilter;
import org.nuxeo.ecm.restapi.server.jaxrs.search.SearchObject;
import org.nuxeo.ecm.webengine.model.exceptions.IllegalParameterException;
import org.nuxeo.ecm.webengine.model.impl.AbstractResource;
import org.nuxeo.ecm.webengine.model.impl.ResourceTypeImpl;
import org.nuxeo.runtime.api.Framework;

public abstract class QueryExecutor
extends AbstractResource<ResourceTypeImpl> {
    public static final String NXQL = "NXQL";
    public static final String QUERY = "query";
    public static final String PAGE_SIZE = "pageSize";
    public static final String CURRENT_PAGE_INDEX = "currentPageIndex";
    public static final String CURRENT_PAGE_OFFSET = "offset";
    public static final String MAX_RESULTS = "maxResults";
    public static final String SORT_BY = "sortBy";
    public static final String SORT_ORDER = "sortOrder";
    public static final String ORDERED_PARAMS = "queryParams";
    public static final String QUICK_FILTERS = "quickFilters";
    public static final String HIGHLIGHT = "highlight";
    public static final String CURRENT_USERID_PATTERN = "$currentUser";
    public static final String CURRENT_REPO_PATTERN = "$currentRepository";
    public static final String SCROLL_PARAM = "scroll";
    public static final String QUERY_LIMIT_PARAM = "queryLimit";
    protected PageProviderService pageProviderService;
    protected boolean skipAggregates;
    private static final Log log = LogFactory.getLog(SearchObject.class);

    public void initExecutor() {
        this.pageProviderService = (PageProviderService)Framework.getService(PageProviderService.class);
        this.skipAggregates = Boolean.parseBoolean((String)this.ctx.getHttpHeaders().getRequestHeaders().getFirst((Object)"skipAggregates"));
    }

    protected String getQuery(MultivaluedMap<String, String> queryParams) {
        String query = (String)queryParams.getFirst((Object)QUERY);
        if (query == null) {
            query = "SELECT * FROM Document";
        }
        return query;
    }

    protected Long getCurrentPageIndex(MultivaluedMap<String, String> queryParams) {
        String currentPageIndex = (String)queryParams.getFirst((Object)CURRENT_PAGE_INDEX);
        if (currentPageIndex != null && !currentPageIndex.isEmpty()) {
            return Long.valueOf(currentPageIndex);
        }
        return null;
    }

    protected Long getCurrentPageOffset(MultivaluedMap<String, String> queryParams) {
        String currentPageOffset = (String)queryParams.getFirst((Object)CURRENT_PAGE_OFFSET);
        if (currentPageOffset != null && !currentPageOffset.isEmpty()) {
            return Long.valueOf(currentPageOffset);
        }
        return null;
    }

    protected Long getPageSize(MultivaluedMap<String, String> queryParams) {
        String pageSize = (String)queryParams.getFirst((Object)PAGE_SIZE);
        if (pageSize != null && !pageSize.isEmpty()) {
            return Long.valueOf(pageSize);
        }
        return null;
    }

    protected Long getMaxResults(MultivaluedMap<String, String> queryParams) {
        String maxResults = (String)queryParams.getFirst((Object)MAX_RESULTS);
        if (maxResults != null && !maxResults.isEmpty()) {
            return Long.valueOf(maxResults);
        }
        return null;
    }

    protected List<SortInfo> getSortInfo(MultivaluedMap<String, String> queryParams) {
        String sortBy = (String)queryParams.getFirst((Object)SORT_BY);
        String sortOrder = (String)queryParams.getFirst((Object)SORT_ORDER);
        return this.getSortInfo(sortBy, sortOrder);
    }

    protected List<SortInfo> getSortInfo(String sortBy, String sortOrder) {
        ArrayList<SortInfo> sortInfoList = null;
        if (!StringUtils.isBlank((CharSequence)sortBy)) {
            String[] sorts = sortBy.split(",");
            String[] orders = null;
            if (!StringUtils.isBlank((CharSequence)sortOrder)) {
                orders = sortOrder.split(",");
            }
            if (sorts.length > 0) {
                sortInfoList = new ArrayList<SortInfo>();
            }
            for (int i = 0; i < sorts.length; ++i) {
                String sort = sorts[i];
                boolean sortAscending = orders != null && orders.length > i && "asc".equals(orders[i].toLowerCase());
                sortInfoList.add(new SortInfo(sort, sortAscending));
            }
        }
        return sortInfoList;
    }

    protected List<QuickFilter> getQuickFilters(String providerName, MultivaluedMap<String, String> queryParams) {
        PageProviderDefinition pageProviderDefinition = this.pageProviderService.getPageProviderDefinition(providerName);
        String quickFilters = (String)queryParams.getFirst((Object)QUICK_FILTERS);
        ArrayList<QuickFilter> quickFilterList = new ArrayList<QuickFilter>();
        if (!StringUtils.isBlank((CharSequence)quickFilters)) {
            String[] filters = quickFilters.split(",");
            List ppQuickFilters = pageProviderDefinition.getQuickFilters();
            block0: for (String filter : filters) {
                for (QuickFilter quickFilter : ppQuickFilters) {
                    if (!quickFilter.getName().equals(filter)) continue;
                    quickFilterList.add(quickFilter);
                    continue block0;
                }
            }
        }
        return quickFilterList;
    }

    protected List<String> getHighlights(MultivaluedMap<String, String> queryParams) {
        String highlight = (String)queryParams.getFirst((Object)HIGHLIGHT);
        List<String> highlightFields = new ArrayList<String>();
        if (!StringUtils.isBlank((CharSequence)highlight)) {
            String[] fields = highlight.split(",");
            highlightFields = Arrays.asList(fields);
        }
        return highlightFields;
    }

    protected Map<String, String> getNamedParameters(MultivaluedMap<String, String> queryParams) {
        HashMap<String, String> namedParameters = new HashMap<String, String>();
        for (String namedParameterKey : queryParams.keySet()) {
            if (EnumUtils.isValidEnum(QueryParams.class, (String)namedParameterKey)) continue;
            String value = (String)queryParams.getFirst((Object)namedParameterKey);
            namedParameters.put(namedParameterKey, this.handleNamedParamVars(value));
        }
        return namedParameters;
    }

    protected Map<String, String> getNamedParameters(Map<String, String> queryParams) {
        HashMap<String, String> namedParameters = new HashMap<String, String>();
        for (String namedParameterKey : queryParams.keySet()) {
            if (EnumUtils.isValidEnum(QueryParams.class, (String)namedParameterKey)) continue;
            String value = queryParams.get(namedParameterKey);
            namedParameters.put(namedParameterKey, this.handleNamedParamVars(value));
        }
        return namedParameters;
    }

    protected String handleNamedParamVars(String value) {
        if (value != null) {
            if (value.equals(CURRENT_USERID_PATTERN)) {
                return this.ctx.getCoreSession().getPrincipal().getName();
            }
            if (value.equals(CURRENT_REPO_PATTERN)) {
                return this.ctx.getCoreSession().getRepositoryName();
            }
        }
        return value;
    }

    protected Object[] getParameters(MultivaluedMap<String, String> queryParams) {
        List orderedParams = (List)queryParams.get((Object)ORDERED_PARAMS);
        if (orderedParams != null && !orderedParams.isEmpty()) {
            Object[] parameters = orderedParams.toArray(new String[orderedParams.size()]);
            this.replaceParameterPattern(parameters);
            return parameters;
        }
        return null;
    }

    protected Object[] replaceParameterPattern(Object[] parameters) {
        for (int idx = 0; idx < parameters.length; ++idx) {
            String value = (String)parameters[idx];
            if (value.equals(CURRENT_USERID_PATTERN)) {
                parameters[idx] = this.ctx.getCoreSession().getPrincipal().getName();
                continue;
            }
            if (!value.equals(CURRENT_REPO_PATTERN)) continue;
            parameters[idx] = this.ctx.getCoreSession().getRepositoryName();
        }
        return parameters;
    }

    protected Map<String, Serializable> getProperties() {
        HashMap<String, Serializable> props = new HashMap<String, Serializable>();
        props.put("coreSession", (Serializable)this.ctx.getCoreSession());
        props.put("skipAggregates", Boolean.valueOf(this.skipAggregates));
        return props;
    }

    protected DocumentModelList queryByLang(String queryLanguage, MultivaluedMap<String, String> queryParams) {
        if (queryLanguage == null || !EnumUtils.isValidEnum(LangParams.class, (String)queryLanguage)) {
            throw new IllegalParameterException("invalid query language");
        }
        return this.queryByLang(queryParams);
    }

    protected DocumentModelList queryByLang(MultivaluedMap<String, String> queryParams) {
        String query = this.getQuery(queryParams);
        Long pageSize = this.getPageSize(queryParams);
        Long currentPageIndex = this.getCurrentPageIndex(queryParams);
        Long currentPageOffset = this.getCurrentPageOffset(queryParams);
        Long maxResults = this.getMaxResults(queryParams);
        Map<String, String> namedParameters = this.getNamedParameters(queryParams);
        Object[] parameters = this.getParameters(queryParams);
        List<SortInfo> sortInfo = this.getSortInfo(queryParams);
        Map<String, Serializable> props = this.getProperties();
        DocumentModel searchDocumentModel = PageProviderHelper.getSearchDocumentModel((CoreSession)this.ctx.getCoreSession(), null, namedParameters);
        return this.queryByLang(query, pageSize, currentPageIndex, currentPageOffset, maxResults, sortInfo, props, searchDocumentModel, parameters);
    }

    protected DocumentModelList queryByPageProvider(String pageProviderName, MultivaluedMap<String, String> queryParams) {
        if (pageProviderName == null) {
            throw new IllegalParameterException("invalid page provider name");
        }
        Long pageSize = this.getPageSize(queryParams);
        Long currentPageIndex = this.getCurrentPageIndex(queryParams);
        Long currentPageOffset = this.getCurrentPageOffset(queryParams);
        Map<String, String> namedParameters = this.getNamedParameters(queryParams);
        Object[] parameters = this.getParameters(queryParams);
        List<SortInfo> sortInfo = this.getSortInfo(queryParams);
        List<QuickFilter> quickFilters = this.getQuickFilters(pageProviderName, queryParams);
        List<String> highlights = this.getHighlights(queryParams);
        Map<String, Serializable> props = this.getProperties();
        DocumentModel searchDocumentModel = PageProviderHelper.getSearchDocumentModel((CoreSession)this.ctx.getCoreSession(), (String)pageProviderName, namedParameters);
        return this.queryByPageProvider(pageProviderName, pageSize, currentPageIndex, currentPageOffset, sortInfo, highlights, quickFilters, props, searchDocumentModel, parameters);
    }

    protected DocumentModelList queryByLang(String query, Long pageSize, Long currentPageIndex, Long currentPageOffset, Long maxResults, List<SortInfo> sortInfo, Map<String, Serializable> props, DocumentModel searchDocumentModel, Object ... parameters) {
        PaginableDocumentModelListImpl res;
        PageProviderDefinition ppdefinition = this.pageProviderService.getPageProviderDefinition("REST_API_SEARCH_ADAPTER");
        ppdefinition.setPattern(query);
        if (maxResults != null && maxResults != -1L) {
            ppdefinition.getProperties().put(MAX_RESULTS, maxResults.toString());
        }
        if ((res = new PaginableDocumentModelListImpl(this.pageProviderService.getPageProvider("REST_API_SEARCH_ADAPTER", ppdefinition, searchDocumentModel, sortInfo, pageSize, currentPageIndex, currentPageOffset, props, null, null, parameters), null)).hasError()) {
            throw new NuxeoException(res.getErrorMessage(), 400);
        }
        return res;
    }

    protected DocumentModelList queryByPageProvider(String pageProviderName, Long pageSize, Long currentPageIndex, Long currentPageOffset, List<SortInfo> sortInfo, List<QuickFilter> quickFilters, Object[] parameters, Map<String, Serializable> props, DocumentModel searchDocumentModel) {
        return this.queryByPageProvider(pageProviderName, pageSize, currentPageIndex, currentPageOffset, sortInfo, null, quickFilters, props, searchDocumentModel, parameters);
    }

    protected DocumentModelList queryByPageProvider(String pageProviderName, Long pageSize, Long currentPageIndex, Long currentPageOffset, List<SortInfo> sortInfo, List<String> highlights, List<QuickFilter> quickFilters, Map<String, Serializable> props, DocumentModel searchDocumentModel, Object ... parameters) {
        PaginableDocumentModelListImpl res = new PaginableDocumentModelListImpl(this.pageProviderService.getPageProvider(pageProviderName, searchDocumentModel, sortInfo, pageSize, currentPageIndex, currentPageOffset, props, highlights, quickFilters, parameters), null);
        if (res.hasError()) {
            throw new NuxeoException(res.getErrorMessage(), 400);
        }
        return res;
    }

    protected PageProviderDefinition getPageProviderDefinition(String pageProviderName) {
        return this.pageProviderService.getPageProviderDefinition(pageProviderName);
    }

    protected Response buildResponse(Response.StatusType status, String type, Object object) throws IOException {
        ObjectMapper mapper = new ObjectMapper();
        String message = mapper.writeValueAsString(object);
        return Response.status((Response.StatusType)status).header("Content-Length", (Object)message.getBytes("UTF-8").length).type(type + "; charset=UTF-8").entity((Object)message).build();
    }

    protected List<String> asStringList(String value) {
        return StringUtils.isBlank((CharSequence)value) ? null : Arrays.asList(value.split(","));
    }

    public static enum LangParams {
        NXQL;

    }

    public static enum QueryParams {
        PAGE_SIZE,
        CURRENT_PAGE_INDEX,
        MAX_RESULTS,
        SORT_BY,
        SORT_ORDER,
        ORDERED_PARAMS,
        QUERY;

    }
}

