/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.webdav.backend;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentNotFoundException;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.IdRef;

@Deprecated
public class PathCache {
    private static final long FOLDER_LIFE_TIME = 1800000L;
    private static final long FILE_LIFE_TIME = 60000L;
    private int maxSize;
    private Map<String, Value> pathToUuidCache = new ConcurrentHashMap<String, Value>();
    private CoreSession session;

    public PathCache(CoreSession session, int maxSize) {
        this.session = session;
        this.maxSize = maxSize;
    }

    public void put(String path, DocumentModel model) {
        if (model == null) {
            return;
        }
        if (this.pathToUuidCache.size() >= this.maxSize) {
            this.clean();
        }
        this.pathToUuidCache.put(path, new Value(System.currentTimeMillis() + (model.isFolder() ? 1800000L : 60000L), model.getId()));
    }

    public DocumentModel get(String path) {
        Value value = this.pathToUuidCache.get(path);
        if (value == null) {
            return null;
        }
        if (value.getExpiredTime() < System.currentTimeMillis()) {
            this.pathToUuidCache.remove(path);
            return null;
        }
        String uuid = value.getValue();
        DocumentModel model = null;
        try {
            model = this.session.getDocument((DocumentRef)new IdRef(uuid));
        }
        catch (DocumentNotFoundException documentNotFoundException) {
            // empty catch block
        }
        if (model == null) {
            this.pathToUuidCache.remove(path);
        }
        return model;
    }

    public void remove(String path) {
        HashMap<String, Value> cacheCopy = new HashMap<String, Value>(this.pathToUuidCache);
        for (String key : cacheCopy.keySet()) {
            if (!key.startsWith(path)) continue;
            this.pathToUuidCache.remove(key);
        }
    }

    private int clean() {
        HashMap<String, Value> tmpMap = new HashMap<String, Value>(this.pathToUuidCache);
        for (String key : tmpMap.keySet()) {
            if (this.pathToUuidCache.get(key).getExpiredTime() >= System.currentTimeMillis()) continue;
            this.remove(key);
        }
        return this.pathToUuidCache.size();
    }

    private class Value {
        private long expiredTime;
        private String value;

        private Value(long expiredTime, String value) {
            this.expiredTime = expiredTime;
            this.value = value;
        }

        public long getExpiredTime() {
            return this.expiredTime;
        }

        public void setExpiredTime(long expiredTime) {
            this.expiredTime = expiredTime;
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }
    }
}

