/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.elasticsearch.audit.io;

import java.util.Map;
import org.codehaus.jackson.JsonGenerator;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.joda.time.format.ISODateTimeFormat;
import org.nuxeo.ecm.platform.audit.api.ExtendedInfo;
import org.nuxeo.ecm.platform.audit.api.LogEntry;

public class AuditEntryJSONWriter {
    public static void asJSON(JsonGenerator jg, LogEntry logEntry) throws Exception {
        jg.writeStartObject();
        jg.writeStringField("entity-type", "logEntry");
        AuditEntryJSONWriter.writeField(jg, "category", logEntry.getCategory());
        AuditEntryJSONWriter.writeField(jg, "principalName", logEntry.getPrincipalName());
        AuditEntryJSONWriter.writeField(jg, "comment", logEntry.getComment());
        AuditEntryJSONWriter.writeField(jg, "docLifeCycle", logEntry.getDocLifeCycle());
        AuditEntryJSONWriter.writeField(jg, "docPath", logEntry.getDocPath());
        AuditEntryJSONWriter.writeField(jg, "docType", logEntry.getDocType());
        AuditEntryJSONWriter.writeField(jg, "docUUID", logEntry.getDocUUID());
        AuditEntryJSONWriter.writeField(jg, "eventId", logEntry.getEventId());
        AuditEntryJSONWriter.writeField(jg, "repositoryId", logEntry.getRepositoryId());
        jg.writeStringField("eventDate", ISODateTimeFormat.dateTime().print((ReadableInstant)new DateTime((Object)logEntry.getEventDate())));
        jg.writeNumberField("id", logEntry.getId());
        jg.writeStringField("logDate", ISODateTimeFormat.dateTime().print((ReadableInstant)new DateTime((Object)logEntry.getLogDate())));
        Map extended = logEntry.getExtendedInfos();
        jg.writeObjectFieldStart("extended");
        for (String key : extended.keySet()) {
            ExtendedInfo ei = (ExtendedInfo)extended.get(key);
            if (ei != null && ei.getSerializableValue() != null) {
                jg.writeStringField(key, ei.getSerializableValue().toString());
                continue;
            }
            jg.writeNullField(key);
        }
        jg.writeEndObject();
        jg.writeEndObject();
        jg.flush();
    }

    protected static void writeField(JsonGenerator jg, String name, String value) throws Exception {
        if (value == null) {
            jg.writeNullField(name);
        } else {
            jg.writeStringField(name, value);
        }
    }
}

