/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.launcher.connect;

import java.io.Console;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.collections.ListUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.common.Environment;
import org.nuxeo.connect.CallbackHolder;
import org.nuxeo.connect.NuxeoConnectClient;
import org.nuxeo.connect.connector.ConnectServerError;
import org.nuxeo.connect.data.DownloadablePackage;
import org.nuxeo.connect.data.DownloadingPackage;
import org.nuxeo.connect.identity.LogicalInstanceIdentifier;
import org.nuxeo.connect.packages.PackageManager;
import org.nuxeo.connect.packages.dependencies.CUDFHelper;
import org.nuxeo.connect.packages.dependencies.DependencyResolution;
import org.nuxeo.connect.update.LocalPackage;
import org.nuxeo.connect.update.Package;
import org.nuxeo.connect.update.PackageException;
import org.nuxeo.connect.update.PackageState;
import org.nuxeo.connect.update.PackageType;
import org.nuxeo.connect.update.PackageUtils;
import org.nuxeo.connect.update.PackageVisibility;
import org.nuxeo.connect.update.ValidationStatus;
import org.nuxeo.connect.update.Version;
import org.nuxeo.connect.update.model.PackageDefinition;
import org.nuxeo.connect.update.standalone.StandaloneUpdateService;
import org.nuxeo.connect.update.task.Task;
import org.nuxeo.launcher.connect.StandaloneCallbackHolder;
import org.nuxeo.launcher.info.CommandInfo;
import org.nuxeo.launcher.info.CommandSetInfo;
import org.nuxeo.launcher.info.PackageInfo;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;

public class ConnectBroker {
    private static final Log log = LogFactory.getLog(ConnectBroker.class);
    public static final String PARAM_MP_DIR = "nuxeo.distribution.marketplace.dir";
    public static final String DISTRIBUTION_MP_DIR_DEFAULT = "setupWizardDownloads";
    public static final String PACKAGES_XML = "packages.xml";
    protected static final String LAUNCHER_CHANGED_PROPERTY = "launcher.changed";
    protected static final int LAUNCHER_CHANGED_EXIT_CODE = 128;
    public static final String[] POSITIVE_ANSWERS = new String[]{"true", "yes", "y"};
    private Environment env;
    private StandaloneUpdateService service;
    private CallbackHolder cbHolder;
    private CommandSetInfo cset = new CommandSetInfo();
    private String targetPlatform;
    private String distributionMPDir;
    private String relax = "ask";
    public static final String OPTION_RELAX_DEFAULT = "ask";
    private String accept = "ask";
    private boolean allowSNAPSHOT = CUDFHelper.defaultAllowSNAPSHOT;
    public static final String OPTION_ACCEPT_DEFAULT = "ask";

    public ConnectBroker(Environment env) throws IOException, PackageException {
        this.env = env;
        this.service = new StandaloneUpdateService(env);
        this.service.initialize();
        this.cbHolder = new StandaloneCallbackHolder(env, this.service);
        NuxeoConnectClient.setCallBackHolder((CallbackHolder)this.cbHolder);
        this.targetPlatform = env.getProperty("org.nuxeo.distribution.name") + "-" + env.getProperty("org.nuxeo.distribution.version");
        this.distributionMPDir = env.getProperty(PARAM_MP_DIR, DISTRIBUTION_MP_DIR_DEFAULT);
    }

    public String getCLID() throws LogicalInstanceIdentifier.NoCLID {
        return LogicalInstanceIdentifier.instance().getCLID();
    }

    public void setCLID(String file) throws LogicalInstanceIdentifier.NoCLID {
        try {
            LogicalInstanceIdentifier.load((String)file);
        }
        catch (IOException | LogicalInstanceIdentifier.InvalidCLID e) {
            throw new LogicalInstanceIdentifier.NoCLID("can not load CLID", (Exception)e);
        }
    }

    public StandaloneUpdateService getUpdateService() {
        return this.service;
    }

    public PackageManager getPackageManager() {
        return NuxeoConnectClient.getPackageManager();
    }

    public void refreshCache() {
        this.getPackageManager().flushCache();
        NuxeoConnectClient.getPackageManager().listAllPackages();
    }

    public CommandSetInfo getCommandSet() {
        return this.cset;
    }

    protected LocalPackage getInstalledPackage(String pkgName) {
        try {
            return this.service.getPersistence().getActivePackage(pkgName);
        }
        catch (PackageException e) {
            log.error((Object)e);
            return null;
        }
    }

    protected boolean isInstalledPackage(String pkgName) {
        return this.service.getPersistence().getActivePackageId(pkgName) != null;
    }

    protected boolean isLocalPackageId(String pkgId) {
        try {
            return this.service.getPackage(pkgId) != null;
        }
        catch (PackageException e) {
            log.error((Object)("Error looking for local package " + pkgId), (Throwable)e);
            return false;
        }
    }

    protected boolean isRemotePackageId(String pkgId) {
        return PackageUtils.isValidPackageId((String)pkgId) && NuxeoConnectClient.getPackageManager().findPackageById(pkgId) != null;
    }

    protected String getBestIdForNameInList(String pkgName, List<? extends Package> pkgList) {
        String foundId = null;
        TreeMap<Version, String> foundPkgs = new TreeMap<Version, String>();
        TreeMap<Version, String> matchingPkgs = new TreeMap<Version, String>();
        for (Package package_ : pkgList) {
            if (!package_.getName().equals(pkgName)) continue;
            foundPkgs.put(package_.getVersion(), package_.getId());
            if (!Arrays.asList(package_.getTargetPlatforms()).contains(this.targetPlatform)) continue;
            matchingPkgs.put(package_.getVersion(), package_.getId());
        }
        if (matchingPkgs.size() != 0) {
            foundId = (String)matchingPkgs.get(matchingPkgs.lastKey());
        } else if (foundPkgs.size() != 0) {
            foundId = (String)foundPkgs.get(foundPkgs.lastKey());
        }
        return foundId;
    }

    protected String getLocalPackageIdFromName(String pkgName) {
        return this.getBestIdForNameInList(pkgName, this.getPkgList());
    }

    protected List<String> getAllLocalPackageIdsFromName(String pkgName) {
        ArrayList<String> foundIds = new ArrayList<String>();
        for (Package package_ : this.getPkgList()) {
            if (!package_.getName().equals(pkgName)) continue;
            foundIds.add(package_.getId());
        }
        return foundIds;
    }

    protected String getInstalledPackageIdFromName(String pkgName) {
        List<LocalPackage> localPackages = this.getPkgList();
        ArrayList<LocalPackage> installedPackages = new ArrayList<LocalPackage>();
        for (LocalPackage pkg : localPackages) {
            if (!pkg.getPackageState().isInstalled()) continue;
            installedPackages.add(pkg);
        }
        return this.getBestIdForNameInList(pkgName, installedPackages);
    }

    protected String getRemotePackageIdFromName(String pkgName) {
        return this.getBestIdForNameInList(pkgName, NuxeoConnectClient.getPackageManager().findRemotePackages(pkgName));
    }

    protected String getRemotePackageId(String pkgNameOrId) {
        String pkgId = null;
        pkgId = this.isRemotePackageId(pkgNameOrId) ? pkgNameOrId : this.getRemotePackageIdFromName(pkgNameOrId);
        return pkgId;
    }

    protected LocalPackage getLocalPackage(String pkgIdOrName) throws PackageException {
        String pkgId;
        LocalPackage pkg = this.service.getPackage(pkgIdOrName);
        if (pkg == null && (pkgId = this.getLocalPackageIdFromName(pkgIdOrName)) != null) {
            pkg = this.service.getPackage(pkgId);
        }
        return pkg;
    }

    protected File getLocalPackageFile(String pkgFile) {
        File fileToCheck;
        if (pkgFile.startsWith("file:")) {
            pkgFile = pkgFile.substring(5);
        }
        if (!(fileToCheck = new File(pkgFile)).exists()) {
            fileToCheck = new File(this.env.getServerHome(), pkgFile);
        }
        if (fileToCheck.exists()) {
            return fileToCheck;
        }
        return null;
    }

    protected boolean isLocalPackageFile(String pkgFile) {
        return this.getLocalPackageFile(pkgFile) != null;
    }

    protected List<String> getDistributionFilenames() {
        File distributionMPFile = new File(this.distributionMPDir, PACKAGES_XML);
        ArrayList<String> md5Filenames = new ArrayList<String>();
        DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
        docFactory.setNamespaceAware(true);
        try {
            DocumentBuilder builder = docFactory.newDocumentBuilder();
            Document doc = builder.parse(distributionMPFile);
            XPathFactory xpFactory = XPathFactory.newInstance();
            XPath xpath = xpFactory.newXPath();
            XPathExpression expr = xpath.compile("//package/@md5");
            NodeList nodes = (NodeList)expr.evaluate(doc, XPathConstants.NODESET);
            for (int i = 0; i < nodes.getLength(); ++i) {
                String md5 = nodes.item(i).getNodeValue();
                if (md5 == null || md5.length() <= 0) continue;
                md5Filenames.add(md5);
            }
        }
        catch (Exception e) {
            log.error((Object)("Failed parsing " + distributionMPFile), (Throwable)e);
            return new ArrayList<String>();
        }
        return md5Filenames;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Map<String, PackageDefinition> getDistributionDefinitions(List<String> md5Filenames) {
        HashMap<String, PackageDefinition> allDefinitions = new HashMap<String, PackageDefinition>();
        if (md5Filenames == null) {
            return allDefinitions;
        }
        for (String md5Filename : md5Filenames) {
            ZipFile zipFile;
            File md5File = new File(this.distributionMPDir, md5Filename);
            if (!md5File.exists()) continue;
            try {
                zipFile = new ZipFile(md5File);
            }
            catch (ZipException e) {
                log.warn((Object)("Unzip error reading file " + md5File), (Throwable)e);
                continue;
            }
            catch (IOException e) {
                log.warn((Object)("Could not read file " + md5File), (Throwable)e);
                continue;
            }
            try {
                ZipEntry zipEntry = zipFile.getEntry("package.xml");
                InputStream in = zipFile.getInputStream(zipEntry);
                PackageDefinition pd = NuxeoConnectClient.getPackageUpdateService().loadPackage(in);
                allDefinitions.put(md5Filename, pd);
            }
            catch (Exception e) {
                log.error((Object)"Could not read package description", (Throwable)e);
            }
            finally {
                try {
                    zipFile.close();
                }
                catch (IOException e) {
                    log.warn((Object)("Unexpected error closing file " + md5File), (Throwable)e);
                }
            }
        }
        return allDefinitions;
    }

    protected boolean addDistributionPackage(String md5) {
        boolean ret = true;
        File distributionFile = new File(this.distributionMPDir, md5);
        if (distributionFile.exists()) {
            try {
                ret = this.pkgAdd(distributionFile.getCanonicalPath()) != null;
            }
            catch (IOException e) {
                log.warn((Object)("Could not add distribution file " + md5));
                ret = false;
            }
        }
        return ret;
    }

    public boolean addDistributionPackages() {
        Map<String, PackageDefinition> distributionPackages = this.getDistributionDefinitions(this.getDistributionFilenames());
        if (distributionPackages.isEmpty()) {
            return true;
        }
        List<LocalPackage> localPackages = this.getPkgList();
        HashMap<String, LocalPackage> localPackagesById = new HashMap<String, LocalPackage>();
        if (localPackages != null) {
            for (LocalPackage pkg : localPackages) {
                localPackagesById.put(pkg.getId(), pkg);
            }
        }
        boolean ret = true;
        for (String md5 : distributionPackages.keySet()) {
            PackageDefinition md5Pkg = distributionPackages.get(md5);
            if (localPackagesById.containsKey(md5Pkg.getId())) {
                LocalPackage localPackage = (LocalPackage)localPackagesById.get(md5Pkg.getId());
                if (!localPackage.getVersion().isSnapshot() || localPackage.getPackageState().isInstalled()) continue;
                this.pkgRemove(localPackage.getId());
                ret = this.addDistributionPackage(md5) && ret;
                continue;
            }
            ret = this.addDistributionPackage(md5) && ret;
        }
        return ret;
    }

    public List<LocalPackage> getPkgList() {
        try {
            return this.service.getPackages();
        }
        catch (PackageException e) {
            log.error((Object)"Could not read package list", (Throwable)e);
            return null;
        }
    }

    public void pkgList() {
        log.info((Object)"Local packages:");
        this.pkgList(this.getPkgList());
    }

    public void pkgListAll() {
        log.info((Object)"All packages:");
        this.pkgList(NuxeoConnectClient.getPackageManager().listAllPackages());
    }

    public void pkgList(List<? extends Package> packagesList) {
        CommandInfo cmdInfo = this.cset.newCommandInfo("list");
        try {
            if (packagesList.isEmpty()) {
                log.info((Object)"None");
            } else {
                NuxeoConnectClient.getPackageManager().sort(packagesList);
                StringBuilder sb = new StringBuilder();
                for (Package package_ : packagesList) {
                    this.newPackageInfo(cmdInfo, package_);
                    PackageState packageState = package_.getPackageState();
                    String packageDescription = packageState.getLabel();
                    packageDescription = String.format("%6s %11s\t", package_.getType(), packageDescription);
                    if (packageState == PackageState.REMOTE && package_.getType() != PackageType.STUDIO && package_.getVisibility() != PackageVisibility.PUBLIC && !LogicalInstanceIdentifier.isRegistered()) {
                        packageDescription = packageDescription + "Registration required for ";
                    }
                    packageDescription = packageDescription + String.format("%s (id: %s)\n", package_.getName(), package_.getId());
                    sb.append(packageDescription);
                }
                log.info((Object)sb.toString());
            }
        }
        catch (Exception e) {
            log.error((Object)e);
            cmdInfo.exitCode = 1;
        }
    }

    protected void performTask(Task task) throws PackageException {
        ValidationStatus validationStatus = task.validate();
        if (validationStatus.hasErrors()) {
            throw new PackageException("Failed to validate package " + task.getPackage().getId() + " -> " + validationStatus.getErrors());
        }
        if (validationStatus.hasWarnings()) {
            log.warn((Object)("Got warnings on package validation " + task.getPackage().getId() + " -> " + validationStatus.getWarnings()));
        }
        task.run(null);
    }

    public boolean pkgReset() {
        CommandInfo cmdInfo = this.cset.newCommandInfo("reset");
        if ("ask".equalsIgnoreCase(this.accept)) {
            this.accept = this.readConsole("The reset will erase Marketplace packages history.\nDo you want to continue (yes/no)? [yes] ", "yes", new Object[0]);
        }
        if (!Boolean.parseBoolean(this.accept)) {
            cmdInfo.exitCode = 1;
            return false;
        }
        try {
            this.service.reset();
            log.info((Object)"Packages reset done: all packages were marked as DOWNLOADED");
            List localPackages = this.service.getPackages();
            for (LocalPackage localPackage : localPackages) {
                localPackage.getUninstallFile().delete();
                FileUtils.deleteDirectory((File)localPackage.getData().getEntry("backup"));
                this.newPackageInfo(cmdInfo, (Package)localPackage);
            }
            this.service.getRegistry().delete();
            FileUtils.deleteDirectory((File)this.service.getBackupDir());
        }
        catch (PackageException e) {
            log.error((Object)e);
            cmdInfo.exitCode = 1;
        }
        catch (IOException e) {
            log.error((Object)e);
            cmdInfo.exitCode = 1;
        }
        return cmdInfo.exitCode == 0;
    }

    public boolean pkgPurge() throws PackageException {
        ArrayList<String> localNames = new ArrayList<String>();
        for (LocalPackage pkg : this.service.getPackages()) {
            if (pkg.getPackageState() != PackageState.DOWNLOADED) continue;
            this.pkgRemove(pkg.getId());
        }
        for (LocalPackage pkg : this.service.getPackages()) {
            localNames.add(pkg.getName());
        }
        return this.pkgRequest(null, null, null, localNames);
    }

    public boolean pkgUninstall(List<String> packageIdsToRemove) {
        log.debug((Object)("Uninstalling: " + packageIdsToRemove));
        for (String pkgId : packageIdsToRemove) {
            if (this.pkgUninstall(pkgId) != null) continue;
            log.error((Object)("Unable to uninstall " + pkgId));
            return false;
        }
        return true;
    }

    public LocalPackage pkgUninstall(String pkgId) {
        if (this.env.getProperty(LAUNCHER_CHANGED_PROPERTY, "false").equals("true")) {
            System.exit(128);
        }
        CommandInfo cmdInfo = this.cset.newCommandInfo("uninstall");
        cmdInfo.param = pkgId;
        try {
            String realPkgId;
            LocalPackage pkg = this.service.getPackage(pkgId);
            if (pkg == null && (realPkgId = this.getInstalledPackageIdFromName(pkgId)) != null) {
                pkgId = realPkgId;
                pkg = this.service.getPackage(realPkgId);
            }
            if (pkg == null) {
                throw new PackageException("Package not found: " + pkgId);
            }
            log.info((Object)("Uninstalling " + pkgId));
            Task uninstallTask = pkg.getUninstallTask();
            try {
                this.performTask(uninstallTask);
            }
            catch (PackageException e) {
                uninstallTask.rollback();
                throw e;
            }
            pkg = this.service.getPackage(pkgId);
            this.newPackageInfo(cmdInfo, (Package)pkg);
            return pkg;
        }
        catch (Exception e) {
            log.error((Object)("Failed to uninstall package: " + pkgId), (Throwable)e);
            cmdInfo.exitCode = 1;
            return null;
        }
    }

    public boolean pkgRemove(List<String> pkgsToRemove) {
        boolean cmdOk = true;
        if (pkgsToRemove != null) {
            log.debug((Object)("Removing: " + pkgsToRemove));
            for (String pkgNameOrId : pkgsToRemove) {
                List<Object> allIds;
                if (this.isLocalPackageId(pkgNameOrId)) {
                    allIds = new ArrayList();
                    allIds.add(pkgNameOrId);
                } else {
                    allIds = this.getAllLocalPackageIdsFromName(pkgNameOrId);
                }
                for (String string : allIds) {
                    if (this.pkgRemove(string) != null) continue;
                    log.warn((Object)("Unable to remove " + string));
                    cmdOk = false;
                }
            }
        }
        return cmdOk;
    }

    public LocalPackage pkgRemove(String pkgId) {
        CommandInfo cmdInfo = this.cset.newCommandInfo("remove");
        cmdInfo.param = pkgId;
        try {
            String realPkgId;
            LocalPackage pkg = this.service.getPackage(pkgId);
            if (pkg == null && (realPkgId = this.getLocalPackageIdFromName(pkgId)) != null) {
                pkgId = realPkgId;
                pkg = this.service.getPackage(realPkgId);
            }
            if (pkg == null) {
                throw new PackageException("Package not found: " + pkgId);
            }
            if (pkg.getPackageState().isInstalled()) {
                this.pkgUninstall(pkgId);
                pkg = this.service.getPackage(pkgId);
            }
            if (pkg.getPackageState() != PackageState.DOWNLOADED) {
                throw new PackageException("Can only remove packages in DOWNLOADED, INSTALLED or STARTED state");
            }
            this.service.removePackage(pkgId);
            log.info((Object)("Removed " + pkgId));
            this.newPackageInfo((CommandInfo)cmdInfo, (Package)pkg).state = PackageState.REMOTE;
            return pkg;
        }
        catch (Exception e) {
            log.error((Object)("Failed to remove package: " + pkgId), (Throwable)e);
            cmdInfo.exitCode = 1;
            return null;
        }
    }

    public boolean pkgAdd(List<String> pkgsToAdd) {
        return this.pkgAdd(pkgsToAdd, false);
    }

    public boolean pkgAdd(List<String> pkgsToAdd, boolean ignoreMissing) {
        boolean cmdOk = true;
        if (pkgsToAdd == null || pkgsToAdd.isEmpty()) {
            return cmdOk;
        }
        ArrayList<String> pkgIdsToDownload = new ArrayList<String>();
        for (String pkgToAdd : pkgsToAdd) {
            CommandInfo cmdInfo = this.cset.newCommandInfo("add");
            cmdInfo.param = pkgToAdd;
            try {
                File fileToAdd = this.getLocalPackageFile(pkgToAdd);
                if (fileToAdd == null) {
                    String pkgId = this.getRemotePackageId(pkgToAdd);
                    if (pkgId == null) {
                        if (ignoreMissing) {
                            log.warn((Object)("Could not add package: " + pkgToAdd));
                            cmdInfo.newMessage(3, "Could not add package.");
                            continue;
                        }
                        throw new PackageException("Could not find a remote or local (relative to current directory or to NUXEO_HOME) package with name or ID " + pkgToAdd);
                    }
                    cmdInfo.newMessage(3, "Waiting for download...");
                    pkgIdsToDownload.add(pkgId);
                    continue;
                }
                LocalPackage pkg = this.service.addPackage(fileToAdd);
                log.info((Object)("Added " + pkg));
                this.newPackageInfo(cmdInfo, (Package)pkg);
            }
            catch (PackageException e) {
                cmdOk = false;
                cmdInfo.exitCode = 1;
                cmdInfo.newMessage((Exception)((Object)e));
            }
        }
        cmdOk = this.downloadPackages(pkgIdsToDownload) && cmdOk;
        return cmdOk;
    }

    public LocalPackage pkgAdd(String packageFileName) {
        return this.pkgAdd(packageFileName, false);
    }

    public LocalPackage pkgAdd(String packageFileName, boolean ignoreMissing) {
        CommandInfo cmdInfo = this.cset.newCommandInfo("add");
        cmdInfo.param = packageFileName;
        LocalPackage pkg = null;
        try {
            File fileToAdd = this.getLocalPackageFile(packageFileName);
            if (fileToAdd == null) {
                String pkgId = this.getRemotePackageId(packageFileName);
                if (pkgId == null) {
                    if (ignoreMissing) {
                        log.warn((Object)("Could not add package: " + packageFileName));
                        cmdInfo.newMessage(3, "Could not add package.");
                        return null;
                    }
                    throw new PackageException("Could not find a remote or local (relative to current directory or to NUXEO_HOME) package with name or ID " + packageFileName);
                }
                if (!this.downloadPackages(Arrays.asList(pkgId))) {
                    throw new PackageException("Could not download package " + pkgId);
                }
                pkg = this.service.getPackage(pkgId);
                if (pkg == null) {
                    throw new PackageException("Could not find downloaded package in cache " + pkgId);
                }
            } else {
                pkg = this.service.addPackage(fileToAdd);
            }
            log.info((Object)("Added " + packageFileName));
            this.newPackageInfo(cmdInfo, (Package)pkg);
        }
        catch (PackageException e) {
            cmdInfo.exitCode = 1;
            cmdInfo.newMessage((Exception)((Object)e));
        }
        return pkg;
    }

    public boolean pkgInstall(List<String> packageIdsToInstall) {
        return this.pkgInstall(packageIdsToInstall, false);
    }

    public boolean pkgInstall(List<String> packageIdsToInstall, boolean ignoreMissing) {
        log.debug((Object)("Installing: " + packageIdsToInstall));
        for (String pkgId : packageIdsToInstall) {
            if (this.pkgInstall(pkgId, ignoreMissing) != null || ignoreMissing) continue;
            return false;
        }
        return true;
    }

    public LocalPackage pkgInstall(String pkgId) {
        return this.pkgInstall(pkgId, false);
    }

    public LocalPackage pkgInstall(String pkgId, boolean ignoreMissing) {
        if (this.env.getProperty(LAUNCHER_CHANGED_PROPERTY, "false").equals("true")) {
            System.exit(128);
        }
        CommandInfo cmdInfo = this.cset.newCommandInfo("install");
        cmdInfo.param = pkgId;
        try {
            LocalPackage pkg = this.getLocalPackage(pkgId);
            if (pkg != null && pkg.getPackageState().isInstalled()) {
                if (pkg.getVersion().isSnapshot()) {
                    log.info((Object)String.format("Updating package %s...", pkg));
                    this.pkgRemove(pkgId);
                    pkg = null;
                } else {
                    log.info((Object)String.format("Package %s is already installed.", pkg));
                    return pkg;
                }
            }
            if (pkg == null) {
                pkg = this.pkgAdd(pkgId, ignoreMissing);
            }
            if (pkg == null) {
                if (ignoreMissing) {
                    log.warn((Object)("Unable to install package: " + pkgId));
                    return null;
                }
                throw new PackageException("Package not found: " + pkgId);
            }
            cmdInfo.param = pkgId = pkg.getId();
            log.info((Object)("Installing " + pkgId));
            Task installTask = pkg.getInstallTask();
            try {
                this.performTask(installTask);
            }
            catch (PackageException e) {
                installTask.rollback();
                throw e;
            }
            pkg = this.service.getPackage(pkgId);
            this.newPackageInfo(cmdInfo, (Package)pkg);
            return pkg;
        }
        catch (PackageException e) {
            log.error((Object)String.format("Failed to install package: %s (%s)", pkgId, e.getMessage()));
            log.debug((Object)e, (Throwable)e);
            cmdInfo.exitCode = 1;
            cmdInfo.newMessage((Exception)((Object)e));
            return null;
        }
    }

    public boolean listPending(File commandsFile) {
        return this.executePending(commandsFile, false, false);
    }

    public boolean executePending(File commandsFile, boolean doExecute, boolean useResolver) {
        int errorValue = 0;
        if (!commandsFile.isFile()) {
            return false;
        }
        ArrayList<String> pkgsToAdd = new ArrayList<String>();
        ArrayList<String> pkgsToInstall = new ArrayList<String>();
        ArrayList<String> pkgsToUninstall = new ArrayList<String>();
        ArrayList<String> pkgsToRemove = new ArrayList<String>();
        try {
            List lines = FileUtils.readLines((File)commandsFile);
            for (String line : lines) {
                CommandInfo cmdInfo;
                String[] split = (line = line.trim()).split("\\s+", 2);
                if (split.length == 2) {
                    if (split[0].equals("install")) {
                        if (doExecute) {
                            if (useResolver) {
                                pkgsToInstall.add(split[1]);
                            } else {
                                this.pkgInstall(split[1]);
                            }
                        } else {
                            cmdInfo = this.cset.newCommandInfo("install");
                            cmdInfo.param = split[1];
                            cmdInfo.pending = true;
                        }
                    } else if (split[0].equals("add")) {
                        if (doExecute) {
                            if (useResolver) {
                                pkgsToAdd.add(split[1]);
                            } else {
                                this.pkgAdd(split[1]);
                            }
                        } else {
                            cmdInfo = this.cset.newCommandInfo("add");
                            cmdInfo.param = split[1];
                            cmdInfo.pending = true;
                        }
                    } else if (split[0].equals("uninstall")) {
                        if (doExecute) {
                            if (useResolver) {
                                pkgsToUninstall.add(split[1]);
                            } else {
                                this.pkgUninstall(split[1]);
                            }
                        } else {
                            cmdInfo = this.cset.newCommandInfo("uninstall");
                            cmdInfo.param = split[1];
                            cmdInfo.pending = true;
                        }
                    } else if (split[0].equals("remove")) {
                        if (doExecute) {
                            if (useResolver) {
                                pkgsToRemove.add(split[1]);
                            } else {
                                this.pkgRemove(split[1]);
                            }
                        } else {
                            cmdInfo = this.cset.newCommandInfo("remove");
                            cmdInfo.param = split[1];
                            cmdInfo.pending = true;
                        }
                    } else {
                        errorValue = 1;
                    }
                } else if (split.length == 1 && line.length() > 0 && !line.startsWith("#")) {
                    if (doExecute) {
                        if ("init".equals(line)) {
                            if (!this.addDistributionPackages()) {
                                errorValue = 1;
                            }
                        } else if (useResolver) {
                            pkgsToInstall.add(line);
                        } else {
                            this.pkgInstall(line);
                        }
                    } else if ("init".equals(line)) {
                        cmdInfo = this.cset.newCommandInfo("init");
                        cmdInfo.pending = true;
                    } else {
                        cmdInfo = this.cset.newCommandInfo("install");
                        cmdInfo.param = line;
                        cmdInfo.pending = true;
                    }
                }
                if (errorValue == 0) continue;
                log.error((Object)("Error processing pending package/command: " + line));
            }
            if (doExecute) {
                if (useResolver) {
                    String oldAccept = this.accept;
                    String oldRelax = this.relax;
                    this.accept = "true";
                    if ("ask".equalsIgnoreCase(this.relax)) {
                        log.info((Object)"Relax mode changed from 'ask' to 'false' for executing the pending actions.");
                        this.relax = "false";
                    }
                    boolean success = this.pkgRequest(pkgsToAdd, pkgsToInstall, pkgsToUninstall, pkgsToRemove);
                    this.accept = oldAccept;
                    this.relax = oldRelax;
                    if (!success) {
                        errorValue = 2;
                    }
                }
                if (errorValue != 0) {
                    File bak = new File(commandsFile.getPath() + ".bak");
                    bak.delete();
                    commandsFile.renameTo(bak);
                } else {
                    commandsFile.delete();
                }
            } else {
                this.cset.log(true);
            }
        }
        catch (IOException e) {
            log.error((Object)e.getMessage());
        }
        return errorValue == 0;
    }

    protected boolean downloadPackages(List<String> packagesToDownload) {
        boolean isRegistered = LogicalInstanceIdentifier.isRegistered();
        ArrayList<String> packagesAlreadyDownloaded = new ArrayList<String>();
        HashMap<String, String> packagesToRemove = new HashMap<String, String>();
        for (String pkg : packagesToDownload) {
            LocalPackage localPackage;
            try {
                localPackage = this.getLocalPackage(pkg);
            }
            catch (PackageException e) {
                log.error((Object)String.format("Looking for package '%s' in local cache raised an error. Aborting.", pkg), (Throwable)e);
                return false;
            }
            if (localPackage == null) continue;
            if (localPackage.getPackageState().isInstalled()) {
                log.error((Object)String.format("Package '%s' is installed. Download skipped.", pkg));
                packagesAlreadyDownloaded.add(pkg);
                continue;
            }
            if (localPackage.getVersion().isSnapshot()) {
                if (localPackage.getVisibility() != PackageVisibility.PUBLIC && !isRegistered) {
                    log.info((Object)String.format("Update of '%s' requires being registered.", pkg));
                    packagesAlreadyDownloaded.add(pkg);
                    continue;
                }
                log.info((Object)String.format("Download of '%s' will replace the one already in local cache.", pkg));
                packagesToRemove.put(localPackage.getId(), pkg);
                continue;
            }
            log.info((Object)String.format("Package '%s' is already in local cache.", pkg));
            packagesAlreadyDownloaded.add(pkg);
        }
        for (String pkgToRemove : packagesToRemove.keySet()) {
            if (this.pkgRemove(pkgToRemove) != null) continue;
            log.error((Object)String.format("Failed to remove '%s'. Download of '%s' skipped", pkgToRemove, packagesToRemove.get(pkgToRemove)));
            packagesToDownload.remove(packagesToRemove.get(pkgToRemove));
        }
        packagesToDownload.removeAll(packagesAlreadyDownloaded);
        if (packagesToDownload.isEmpty()) {
            return true;
        }
        log.info((Object)("Downloading " + packagesToDownload + "..."));
        boolean downloadOk = true;
        ArrayList<DownloadingPackage> pkgs = new ArrayList<DownloadingPackage>();
        for (String pkg : packagesToDownload) {
            CommandInfo cmdInfo = this.cset.newCommandInfo("download");
            cmdInfo.param = pkg;
            DownloadablePackage downloadablePkg = this.getPackageManager().findRemotePackageById(pkg);
            if (downloadablePkg.getVisibility() != PackageVisibility.PUBLIC && !isRegistered) {
                downloadOk = false;
                cmdInfo.exitCode = 1;
                cmdInfo.newMessage(5, "Registration required.");
                continue;
            }
            try {
                DownloadingPackage download = this.getPackageManager().download(pkg);
                if (download != null) {
                    pkgs.add(download);
                    cmdInfo.param = download.getId();
                    cmdInfo.newMessage(2, "Downloading...");
                    continue;
                }
                downloadOk = false;
                cmdInfo.exitCode = 1;
                cmdInfo.newMessage(5, "Download failed (not found).");
            }
            catch (ConnectServerError e) {
                log.debug((Object)e, (Throwable)e);
                downloadOk = false;
                cmdInfo.exitCode = 1;
                cmdInfo.newMessage(5, "Download failed: " + e.getMessage());
            }
        }
        String progress = "|/-\\";
        int x = 0;
        boolean stopDownload = false;
        do {
            System.out.print("|/-\\".charAt(x++ % "|/-\\".length()) + "\r");
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                stopDownload = true;
            }
            ArrayList<DownloadingPackage> pkgsCompleted = new ArrayList<DownloadingPackage>();
            for (DownloadingPackage pkg : pkgs) {
                if (!pkg.isCompleted()) continue;
                pkgsCompleted.add(pkg);
                CommandInfo cmdInfo = this.cset.newCommandInfo("download");
                cmdInfo.param = pkg.getId();
                if (pkg.getPackageState() == PackageState.DOWNLOADED) {
                    cmdInfo.newMessage(2, "Downloaded.");
                    continue;
                }
                downloadOk = false;
                cmdInfo.exitCode = 1;
                cmdInfo.newMessage(5, "Download failed: " + pkg.getErrorMessage());
                if (!pkg.isServerError()) continue;
                stopDownload = true;
            }
            pkgs.removeAll(pkgsCompleted);
        } while (!stopDownload && pkgs.size() > 0);
        if (pkgs.size() > 0) {
            downloadOk = false;
            log.error((Object)"Packages download was interrupted");
            for (DownloadingPackage pkg : pkgs) {
                CommandInfo cmdInfo = this.cset.newCommandInfo("add");
                cmdInfo.param = pkg.getId();
                cmdInfo.exitCode = 1;
                cmdInfo.newMessage(5, "Download interrupted.");
            }
        }
        return downloadOk;
    }

    public boolean pkgRequest(List<String> pkgsToAdd, List<String> pkgsToInstall, List<String> pkgsToUninstall, List<String> pkgsToRemove) {
        return this.pkgRequest(pkgsToAdd, pkgsToInstall, pkgsToUninstall, pkgsToRemove, true, false);
    }

    public boolean pkgRequest(List<String> pkgsToAdd, List<String> pkgsToInstall, List<String> pkgsToUninstall, List<String> pkgsToRemove, boolean keepExisting) {
        return this.pkgRequest(pkgsToAdd, pkgsToInstall, pkgsToUninstall, pkgsToRemove, keepExisting, false);
    }

    public boolean pkgRequest(List<String> pkgsToAdd, List<String> pkgsToInstall, List<String> pkgsToUninstall, List<String> pkgsToRemove, boolean keepExisting, boolean ignoreMissing) {
        try {
            boolean cmdOk = true;
            cmdOk = this.pkgAdd(pkgsToAdd, ignoreMissing);
            ArrayList<String> solverInstall = new ArrayList<String>();
            ArrayList<String> solverRemove = new ArrayList<String>();
            ArrayList<String> solverUpgrade = new ArrayList<String>();
            if (pkgsToInstall != null) {
                ArrayList<String> namesOrIdsToInstall = new ArrayList<String>();
                for (String string : pkgsToInstall) {
                    if (this.isLocalPackageFile(string)) {
                        LocalPackage localPackage = this.pkgAdd(string);
                        if (localPackage != null) {
                            namesOrIdsToInstall.add(localPackage.getId());
                            continue;
                        }
                        cmdOk = false;
                        continue;
                    }
                    namesOrIdsToInstall.add(string);
                }
                Map allPackagesByID = NuxeoConnectClient.getPackageManager().getAllPackagesByID();
                for (String string : namesOrIdsToInstall) {
                    DownloadablePackage pkg = (DownloadablePackage)allPackagesByID.get(string);
                    if (pkg != null) {
                        if (this.isInstalledPackage(pkg.getName())) {
                            solverUpgrade.add(string);
                            continue;
                        }
                        solverInstall.add(string);
                        continue;
                    }
                    String id = this.getInstalledPackageIdFromName(string);
                    if (id != null) {
                        solverUpgrade.add(string);
                        continue;
                    }
                    solverInstall.add(string);
                }
            }
            if (pkgsToUninstall != null) {
                solverRemove.addAll(pkgsToUninstall);
            }
            if (pkgsToRemove != null) {
                solverRemove.addAll(pkgsToRemove);
            }
            if (solverInstall.size() != 0 || solverRemove.size() != 0 || solverUpgrade.size() != 0) {
                List list;
                String requestPlatform = this.targetPlatform;
                ArrayList<String> requestPackages = new ArrayList<String>();
                requestPackages.addAll(solverInstall);
                requestPackages.addAll(solverRemove);
                requestPackages.addAll(solverUpgrade);
                if (ignoreMissing) {
                    Map map = this.getPackageManager().getAllPackagesByName();
                    ArrayList arrayList = new ArrayList(solverInstall);
                    for (String pkgToInstall : arrayList) {
                        if (map.containsKey(pkgToInstall)) continue;
                        log.warn((Object)("Unable to install unknown package: " + pkgToInstall));
                        solverInstall.remove(pkgToInstall);
                        requestPackages.remove(pkgToInstall);
                    }
                }
                if ((list = this.getPackageManager().getNonCompliantList(requestPackages, this.targetPlatform)).size() > 0) {
                    requestPlatform = null;
                    if ("ask".equalsIgnoreCase(this.relax)) {
                        this.relax = this.readConsole("Package %s not available on platform version %s.\nDo you want to relax the constraint (yes/no)? [no] ", "no", StringUtils.join((Collection)list, (String)", "), this.targetPlatform);
                    }
                    if (Boolean.parseBoolean(this.relax)) {
                        log.warn((Object)String.format("Relax restriction to target platform %s because of package(s) %s", this.targetPlatform, StringUtils.join((Collection)list, (String)", ")));
                    } else if (ignoreMissing) {
                        for (String pkgToInstall : list) {
                            log.warn((Object)("Unable to install package: " + pkgToInstall));
                            solverInstall.remove(pkgToInstall);
                        }
                    } else {
                        throw new PackageException(String.format("Package %s not available on platform version %s (relax is not allowed)", StringUtils.join((Collection)list, (String)", "), this.targetPlatform));
                    }
                }
                log.debug((Object)("solverInstall: " + solverInstall));
                log.debug((Object)("solverRemove: " + solverRemove));
                log.debug((Object)("solverUpgrade: " + solverUpgrade));
                DependencyResolution dependencyResolution = this.getPackageManager().resolveDependencies(solverInstall, solverRemove, solverUpgrade, requestPlatform, this.allowSNAPSHOT, keepExisting);
                log.info((Object)dependencyResolution);
                if (dependencyResolution.isFailed()) {
                    return false;
                }
                if (dependencyResolution.isEmpty()) {
                    this.pkgRemove(pkgsToRemove);
                    return cmdOk;
                }
                if ("ask".equalsIgnoreCase(this.accept)) {
                    this.accept = this.readConsole("Do you want to continue (yes/no)? [yes] ", "yes", new Object[0]);
                }
                if (!Boolean.parseBoolean(this.accept)) {
                    log.warn((Object)"Exit");
                    return false;
                }
                List packageIdsToRemove = dependencyResolution.getOrderedPackageIdsToRemove();
                List packageIdsToUpgrade = dependencyResolution.getUpgradePackageIds();
                List packageIdsToInstall = dependencyResolution.getOrderedPackageIdsToInstall();
                List packagesIdsToReInstall = new ArrayList();
                if (!this.downloadPackages(dependencyResolution.getDownloadPackageIds())) {
                    log.error((Object)"Aborting packages change request");
                    return false;
                }
                if (!packageIdsToUpgrade.isEmpty()) {
                    packageIdsToRemove.addAll(dependencyResolution.getLocalPackagesToUpgrade().keySet());
                    DependencyResolution uninstallResolution = this.getPackageManager().resolveDependencies(null, packageIdsToRemove, null, requestPlatform, this.allowSNAPSHOT, keepExisting);
                    log.debug((Object)("Sub-resolution (uninstall) " + uninstallResolution));
                    if (uninstallResolution.isFailed()) {
                        return false;
                    }
                    List newPackageIdsToRemove = uninstallResolution.getOrderedPackageIdsToRemove();
                    packagesIdsToReInstall = ListUtils.subtract((List)newPackageIdsToRemove, (List)packageIdsToRemove);
                    packagesIdsToReInstall.removeAll(packageIdsToUpgrade);
                    packageIdsToRemove = newPackageIdsToRemove;
                }
                if (!this.pkgUninstall(packageIdsToRemove)) {
                    return false;
                }
                if (!packagesIdsToReInstall.isEmpty()) {
                    packageIdsToInstall.addAll(packagesIdsToReInstall);
                    DependencyResolution installResolution = this.getPackageManager().resolveDependencies(packageIdsToInstall, null, null, requestPlatform, this.allowSNAPSHOT, keepExisting);
                    log.debug((Object)("Sub-resolution (install) " + installResolution));
                    if (installResolution.isFailed()) {
                        return false;
                    }
                    packageIdsToInstall = installResolution.getOrderedPackageIdsToInstall();
                }
                if (!this.pkgInstall(packageIdsToInstall)) {
                    return false;
                }
                this.pkgRemove(pkgsToRemove);
            }
            return cmdOk;
        }
        catch (PackageException e) {
            log.error((Object)e);
            log.debug((Object)e, (Throwable)e);
            return false;
        }
    }

    public boolean pkgSet(List<String> pkgList) {
        return this.pkgSet(pkgList, false);
    }

    public boolean pkgSet(List<String> pkgList, boolean ignoreMissing) {
        boolean cmdOK = true;
        cmdOK = cmdOK && this.pkgInstall(pkgList, ignoreMissing);
        List installedPkgs = this.getPackageManager().listInstalledPackages();
        ArrayList<String> pkgsToUninstall = new ArrayList<String>();
        for (DownloadablePackage pkg : installedPkgs) {
            if (pkgList.contains(pkg.getName()) || pkgList.contains(pkg.getId())) continue;
            pkgsToUninstall.add(pkg.getId());
        }
        if (pkgsToUninstall.size() != 0) {
            cmdOK = cmdOK && this.pkgUninstall(pkgsToUninstall);
        }
        return cmdOK;
    }

    protected String readConsole(String message, String defaultValue, Object ... objects) {
        String answer;
        Console console = System.console();
        if (console == null || StringUtils.isEmpty((String)(answer = console.readLine(message, objects)))) {
            answer = defaultValue;
        }
        answer = answer.trim().toLowerCase();
        return ConnectBroker.parseAnswer(answer);
    }

    public static String parseAnswer(String answer) {
        if ("ask".equalsIgnoreCase(answer)) {
            return "ask";
        }
        if ("false".equalsIgnoreCase(answer)) {
            return "false";
        }
        for (String positive : POSITIVE_ANSWERS) {
            if (!positive.equalsIgnoreCase(answer)) continue;
            return "true";
        }
        return "false";
    }

    protected boolean pkgUpgradeByType(PackageType type) {
        List upgrades = NuxeoConnectClient.getPackageManager().listUpdatePackages(type, this.targetPlatform);
        ArrayList<String> upgradeIds = new ArrayList<String>();
        for (DownloadablePackage upgrade : upgrades) {
            upgradeIds.add(upgrade.getId());
        }
        return this.pkgRequest(null, upgradeIds, null, null);
    }

    public boolean pkgHotfix() {
        return this.pkgUpgradeByType(PackageType.HOT_FIX);
    }

    public boolean pkgUpgrade() {
        return this.pkgUpgradeByType(PackageType.ADDON);
    }

    public void setRelax(String relaxValue) {
        if (relaxValue != null) {
            this.relax = ConnectBroker.parseAnswer(relaxValue);
        }
    }

    public void setAccept(String acceptValue) {
        if (acceptValue != null) {
            this.accept = ConnectBroker.parseAnswer(acceptValue);
            if ("ask".equals(this.accept) || "true".equals(this.accept)) {
                this.setRelax(acceptValue);
            }
        }
    }

    private PackageInfo newPackageInfo(CommandInfo cmdInfo, Package pkg) {
        PackageInfo packageInfo = new PackageInfo(pkg);
        cmdInfo.packages.add(packageInfo);
        return packageInfo;
    }

    public boolean pkgShow(List<String> packages) {
        boolean cmdOk = true;
        if (packages == null || packages.isEmpty()) {
            return cmdOk;
        }
        StringBuilder sb = new StringBuilder();
        sb.append("****************************************");
        for (String pkg : packages) {
            CommandInfo cmdInfo = this.cset.newCommandInfo("show");
            cmdInfo.param = pkg;
            try {
                PackageInfo packageInfo = this.newPackageInfo(cmdInfo, this.findPackage(pkg));
                sb.append("\nPackage: " + packageInfo.id);
                sb.append("\nState: " + packageInfo.state);
                sb.append("\nVersion: " + packageInfo.version);
                sb.append("\nName: " + packageInfo.name);
                sb.append("\nType: " + packageInfo.type);
                sb.append("\nVisibility: " + packageInfo.visibility);
                if (packageInfo.state == PackageState.REMOTE && packageInfo.type != PackageType.STUDIO && packageInfo.visibility != PackageVisibility.PUBLIC && !LogicalInstanceIdentifier.isRegistered()) {
                    sb.append(" (registration required)");
                }
                sb.append("\nTarget platforms: " + ArrayUtils.toString((Object)packageInfo.targetPlatforms));
                this.appendIfNotEmpty(sb, "\nVendor: ", packageInfo.vendor);
                sb.append("\nSupports hot-reload: " + packageInfo.supportsHotReload);
                sb.append("\nSupported: " + packageInfo.supported);
                sb.append("\nProduction state: " + packageInfo.productionState);
                sb.append("\nValidation state: " + packageInfo.validationState);
                this.appendIfNotEmpty(sb, "\nProvides: ", packageInfo.provides);
                this.appendIfNotEmpty(sb, "\nDepends: ", packageInfo.dependencies);
                this.appendIfNotEmpty(sb, "\nConflicts: ", packageInfo.conflicts);
                this.appendIfNotEmpty(sb, "\nTitle: ", packageInfo.title);
                this.appendIfNotEmpty(sb, "\nDescription: ", packageInfo.description);
                this.appendIfNotEmpty(sb, "\nHomepage: ", packageInfo.homePage);
                this.appendIfNotEmpty(sb, "\nLicense: ", packageInfo.licenseType);
                this.appendIfNotEmpty(sb, "\nLicense URL: ", packageInfo.licenseUrl);
                sb.append("\n****************************************");
            }
            catch (PackageException e) {
                cmdOk = false;
                cmdInfo.exitCode = 1;
                cmdInfo.newMessage((Exception)((Object)e));
            }
        }
        log.info((Object)sb.toString());
        return cmdOk;
    }

    private void appendIfNotEmpty(StringBuilder sb, String label, Object[] array) {
        if (ArrayUtils.isNotEmpty((Object[])array)) {
            sb.append(label + ArrayUtils.toString((Object)array));
        }
    }

    private void appendIfNotEmpty(StringBuilder sb, String label, String value) {
        if (StringUtils.isNotEmpty((String)value)) {
            sb.append(label + value);
        }
    }

    protected Package findPackage(String pkg) throws PackageException {
        File localPackageFile = this.getLocalPackageFile(pkg);
        if (localPackageFile != null) {
            return this.service.loadPackageFromZip(localPackageFile);
        }
        LocalPackage localPackage = this.getLocalPackage(pkg);
        if (localPackage != null) {
            return localPackage;
        }
        String pkgId = this.getRemotePackageId(pkg);
        if (pkgId != null) {
            return this.getPackageManager().findPackageById(pkgId);
        }
        throw new PackageException("Could not find a remote or local (relative to current directory or to NUXEO_HOME) package with name or ID " + pkg);
    }

    public void setAllowSNAPSHOT(boolean allow) {
        CUDFHelper.defaultAllowSNAPSHOT = allow;
        this.allowSNAPSHOT = allow;
    }
}

