/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.segment.io.web;

import java.util.HashMap;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.ecm.webengine.model.WebObject;
import org.nuxeo.ecm.webengine.model.impl.ModuleRoot;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.segment.io.SegmentIO;
import org.nuxeo.segment.io.SegmentIOUserFilter;
import org.nuxeo.segment.io.web.MarketoHelper;

@WebObject(type="segmentIOScriptResource")
@Path(value="/segmentIO")
@Produces(value={"application/javascript"})
public class SegmentIOScriptResource
extends ModuleRoot {
    protected static final Log log = LogFactory.getLog(SegmentIOScriptResource.class);

    @GET
    public Object anonymous() {
        return this.buildScript(null);
    }

    @GET
    @Path(value="user/{login}")
    public Object signed(@PathParam(value="login") String login) {
        return this.buildScript(login);
    }

    protected String buildJsonBlackListedLogins() {
        SegmentIO segmentIO = (SegmentIO)Framework.getLocalService(SegmentIO.class);
        SegmentIOUserFilter filters = segmentIO.getUserFilters();
        StringBuffer json = new StringBuffer("[");
        if (filters != null) {
            String anonymous;
            if (!filters.isEnableAnonymous() && (anonymous = filters.getAnonymousUserId()) != null) {
                json.append("'");
                json.append(anonymous);
                json.append("',");
            }
            for (String login : filters.getBlackListedUsers()) {
                json.append("'");
                json.append(login);
                json.append("',");
            }
        }
        json.append("]");
        return json.toString();
    }

    protected Object buildScript(String login) {
        SegmentIO segmentIO = (SegmentIO)Framework.getLocalService(SegmentIO.class);
        HashMap<String, String> ctx = new HashMap<String, String>();
        ctx.put("writeKey", segmentIO.getWriteKey());
        NuxeoPrincipal principal = (NuxeoPrincipal)this.getContext().getPrincipal();
        if (principal != null && (login == null || principal.getName().equals(login))) {
            ctx.put("principal", (String)principal);
        }
        ctx.put("blackListedLogins", this.buildJsonBlackListedLogins());
        return this.getView("script").args(ctx);
    }

    @GET
    @Path(value="test")
    public Object test() {
        return this.getView("test");
    }

    @GET
    @Path(value="marketo/{email}")
    @Produces(value={"text/plain"})
    public String getMarketo(@PathParam(value="email") String email) {
        if (email == null || email.isEmpty()) {
            return "";
        }
        return MarketoHelper.getLeadHash(email);
    }
}

