/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.connect.update.standalone;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import org.junit.Assert;
import org.junit.Test;
import org.nuxeo.common.utils.ZipUtils;
import org.nuxeo.common.xmap.XMap;
import org.nuxeo.connect.update.NuxeoValidationState;
import org.nuxeo.connect.update.PackageState;
import org.nuxeo.connect.update.PackageType;
import org.nuxeo.connect.update.PackageVisibility;
import org.nuxeo.connect.update.ProductionState;
import org.nuxeo.connect.update.standalone.LocalPackageImpl;
import org.nuxeo.connect.update.standalone.PackageTestCase;
import org.nuxeo.connect.update.standalone.StandaloneUpdateService;
import org.nuxeo.connect.update.task.standalone.InstallTask;
import org.nuxeo.connect.update.task.standalone.UninstallTask;
import org.nuxeo.connect.update.util.PackageBuilder;
import org.nuxeo.connect.update.xml.PackageDefinitionImpl;
import org.nuxeo.runtime.api.Framework;

public class TestPackageBuildAndParse
extends PackageTestCase {
    @Test
    public void testBuildAndParse() throws Exception {
        String termsAndConditions = "You have to be crazy to use this package";
        PackageBuilder builder = new PackageBuilder();
        builder.name("nuxeo-automation").version("5.3.2").type(PackageType.ADDON);
        builder.platform("dm-5.3.2");
        builder.platform("dam-5.3.2");
        builder.dependency("nuxeo-core:5.3.1:5.3.2");
        builder.dependency("nuxeo-runtime:5.3.1");
        builder.title("Nuxeo Automation");
        builder.description("A service that enable building complex business logic on top of Nuxeo services using scriptable operation chains");
        builder.classifier("Open Source");
        builder.vendor("Nuxeo");
        builder.installer(InstallTask.class.getName(), true);
        builder.uninstaller(UninstallTask.class.getName(), true);
        builder.addLicense("My test license. All rights reserved.");
        File file = File.createTempFile("nxinstall-file-", ".tmp");
        Framework.trackFile((File)file, (Object)builder);
        File tofile = File.createTempFile("nxinstall-tofile-", ".tmp");
        Framework.trackFile((File)tofile, (Object)builder);
        builder.addInstallScript("<install>\n  <copy file=\"" + file.getAbsolutePath() + "\" tofile=\"" + tofile.getAbsolutePath() + "\" overwrite=\"true\"/>\n</install>\n");
        builder.addTermsAndConditions(termsAndConditions);
        builder.hotReloadSupport(true);
        builder.supported(true);
        builder.validationState(NuxeoValidationState.INPROCESS);
        builder.productionState(ProductionState.PRODUCTION_READY);
        builder.requireTermsAndConditionsAcceptance(true);
        builder.visibility(PackageVisibility.MARKETPLACE);
        String manifest = builder.buildManifest();
        XMap xmap = StandaloneUpdateService.createXmap();
        ByteArrayInputStream xmlIn = new ByteArrayInputStream(manifest.getBytes());
        PackageDefinitionImpl packageDef = (PackageDefinitionImpl)xmap.load((InputStream)xmlIn);
        Assert.assertEquals((Object)"nuxeo-automation", (Object)packageDef.getName());
        Assert.assertEquals((Object)"Nuxeo", (Object)packageDef.getVendor());
        Assert.assertEquals((Object)NuxeoValidationState.INPROCESS, (Object)packageDef.getValidationState());
        Assert.assertEquals((Object)ProductionState.PRODUCTION_READY, (Object)packageDef.getProductionState());
        Assert.assertTrue((boolean)packageDef.requireTermsAndConditionsAcceptance());
        Assert.assertTrue((boolean)packageDef.isSupported());
        Assert.assertTrue((boolean)packageDef.supportsHotReload());
        Assert.assertEquals((Object)PackageVisibility.MARKETPLACE, (Object)packageDef.getVisibility());
        File zipFile = builder.build();
        String tmpDirPath = System.getProperty("java.io.tmpdir") + "/TestPkg" + System.currentTimeMillis();
        File tmpDir = new File(tmpDirPath);
        tmpDir.mkdirs();
        ZipUtils.unzip((File)zipFile, (File)tmpDir);
        LocalPackageImpl pkg = new LocalPackageImpl(tmpDir, PackageState.REMOTE, this.service);
        Framework.trackFile((File)tmpDir, (Object)pkg);
        Assert.assertEquals((Object)termsAndConditions, (Object)pkg.getTermsAndConditionsContent());
        Assert.assertEquals((Object)"nuxeo-automation", (Object)pkg.getName());
        Assert.assertEquals((Object)"Nuxeo", (Object)pkg.getVendor());
        Assert.assertEquals((Object)NuxeoValidationState.INPROCESS, (Object)pkg.getValidationState());
        Assert.assertEquals((Object)ProductionState.PRODUCTION_READY, (Object)pkg.getProductionState());
        Assert.assertTrue((boolean)pkg.requireTermsAndConditionsAcceptance());
        Assert.assertTrue((boolean)pkg.isSupported());
        Assert.assertTrue((boolean)pkg.supportsHotReload());
        Assert.assertEquals((Object)PackageVisibility.MARKETPLACE, (Object)pkg.getVisibility());
    }
}

