/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.redis;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.nuxeo.common.xmap.XMap;
import org.nuxeo.ecm.core.redis.RedisExecutor;
import org.nuxeo.ecm.core.redis.RedisPoolDescriptor;
import org.nuxeo.ecm.core.redis.RedisSentinelDescriptor;
import org.nuxeo.ecm.core.redis.RedisServerDescriptor;
import org.nuxeo.launcher.config.ConfigurationException;
import org.nuxeo.launcher.config.ConfigurationGenerator;
import org.nuxeo.launcher.config.backingservices.BackingChecker;
import redis.clients.jedis.BinaryJedis;

public class RedisChecker
implements BackingChecker {
    private static final String TEMPLATE_NAME = "redis";
    private static final String CONFIG_NAME = "redis-config.xml";

    public boolean accepts(ConfigurationGenerator cg) {
        return cg.getTemplateList().contains(TEMPLATE_NAME);
    }

    public void check(ConfigurationGenerator cg) throws ConfigurationException {
        RedisPoolDescriptor config = this.getConfig(cg);
        RedisExecutor executor = config.newExecutor();
        try {
            String pong = executor.execute(BinaryJedis::ping);
            if (!"PONG".equals(pong)) {
                throw new RuntimeException("Unable to ping Redis, received " + pong);
            }
        }
        catch (RuntimeException e) {
            throw new ConfigurationException("Unable to reach Redis on prefix: " + config.prefix, (Throwable)e);
        }
        finally {
            executor.getPool().close();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected RedisPoolDescriptor getConfig(ConfigurationGenerator cg) throws ConfigurationException {
        File configFile = new File(cg.getConfigDir(), CONFIG_NAME);
        if (!configFile.exists()) {
            throw new ConfigurationException("Cannot find Redis configuration: redis-config.xml");
        }
        XMap xmap = new XMap();
        xmap.register(RedisPoolDescriptor.class);
        xmap.register(RedisServerDescriptor.class);
        xmap.register(RedisSentinelDescriptor.class);
        try (FileInputStream inStream = new FileInputStream(configFile);){
            Object[] nodes;
            Object[] objectArray = nodes = xmap.loadAll((InputStream)inStream);
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object node = objectArray[n2];
                if (node != null) {
                    RedisPoolDescriptor redisPoolDescriptor = (RedisPoolDescriptor)node;
                    return redisPoolDescriptor;
                }
                ++n2;
            }
            throw new ConfigurationException("No RedisPoolDescriptor found in " + configFile.getAbsolutePath());
        }
        catch (IOException e) {
            throw new ConfigurationException("Failed to load RedisPoolDescriptor from " + configFile.getAbsolutePath(), (Throwable)e);
        }
    }
}

