/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.styleguide;

import java.util.List;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.nuxeo.ecm.platform.actions.Action;
import org.nuxeo.ecm.platform.actions.ejb.ActionManager;

@Name(value="styleGuideActions")
@Scope(value=ScopeType.CONVERSATION)
public class StyleGuideActions {
    public static final String PAGE_ACTION_CAT = "STYLE_GUIDE_PAGE";
    @In(create=true, required=false)
    protected transient ActionManager actionManager;
    protected Action currentPage;
    protected List<Action> pages;

    public Action getCurrentPage() {
        if (this.currentPage == null) {
            this.getPages();
            if (this.pages != null && !this.pages.isEmpty()) {
                this.currentPage = this.pages.get(0);
            }
        }
        return this.currentPage;
    }

    public void setCurrentPage(Action currentPage) {
        this.currentPage = currentPage;
    }

    public String getCurrentPageId() {
        Action currentPage = this.getCurrentPage();
        if (currentPage != null) {
            return currentPage.getId();
        }
        return null;
    }

    public void setCurrentPageId(String currentPageId) {
        this.currentPage = this.actionManager.getAction(currentPageId, null, true);
    }

    public List<Action> getPages() {
        if (this.pages == null) {
            this.pages = this.getActions(PAGE_ACTION_CAT);
        }
        return this.pages;
    }

    public List<Action> getActions(String cat) {
        return this.actionManager.getActions(cat, null);
    }
}

