/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.styleguide.service.descriptors;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xml.serialize.OutputFormat;
import org.nuxeo.common.utils.FileUtils;
import org.nuxeo.common.xmap.DOMSerializer;
import org.nuxeo.common.xmap.annotation.XContent;
import org.nuxeo.common.xmap.annotation.XNode;
import org.nuxeo.common.xmap.annotation.XNodeList;
import org.nuxeo.common.xmap.annotation.XObject;
import org.w3c.dom.DocumentFragment;

@XObject(value="icon")
public class IconDescriptor {
    private static final Log log = LogFactory.getLog(IconDescriptor.class);
    @XNode(value="@path")
    protected String path;
    @XNode(value="@enabled")
    protected Boolean enabled = Boolean.TRUE;
    @XNode(value="label")
    protected String label;
    protected String description;
    @XNode(value="sinceVersion")
    protected String sinceVersion;
    @XNodeList(value="categories/category", type=ArrayList.class, componentType=String.class)
    protected List<String> categories;

    public String getPath() {
        return this.path;
    }

    public String getFilename() {
        return FileUtils.getFileName((String)this.path);
    }

    public String getLabel() {
        return this.label;
    }

    public String getDescription() {
        return this.description;
    }

    public String getSinceVersion() {
        return this.sinceVersion;
    }

    public List<String> getCategories() {
        return this.categories;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @XContent(value="description")
    public void setDescription(DocumentFragment descriptionDOM) {
        try {
            OutputFormat of = new OutputFormat();
            of.setOmitXMLDeclaration(true);
            this.description = DOMSerializer.toString((DocumentFragment)descriptionDOM, (OutputFormat)of).trim();
        }
        catch (IOException e) {
            log.error((Object)e, (Throwable)e);
        }
    }

    public void setSinceVersion(String sinceVersion) {
        this.sinceVersion = sinceVersion;
    }

    public void setCategories(List<String> categories) {
        this.categories = categories;
    }

    public Boolean getEnabled() {
        return this.enabled;
    }

    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    public String toString() {
        return this.getPath();
    }
}

